<?php $__env->startSection('page-title', 'Attendance Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-800 rounded-lg shadow-xl border border-gray-700">
    <div class="px-6 py-4 border-b border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-white mb-4 sm:mb-0">
                <i class="fas fa-calendar-check mr-3 text-green-400"></i>
                Attendance Management
            </h1>
            <div class="flex flex-wrap gap-2">
                <?php if(auth()->user()->hasRole('Staff')): ?>
                    <form action="<?php echo e(route('attendance.checkin')); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-sign-in-alt mr-2"></i>Check In
                        </button>
                    </form>
                    <form action="<?php echo e(route('attendance.checkout')); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-sign-out-alt mr-2"></i>Check Out
                        </button>
                    </form>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Attendance::class)): ?>
                    <a href="<?php echo e(route('attendance.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                        <i class="fas fa-plus mr-2"></i>Add Record
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="p-6">
        <?php if($errors->any()): ?>
            <div class="mb-4 bg-red-900 border border-red-700 text-red-300 px-4 py-3 rounded-md">
                <div class="flex items-center">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    <div>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div><?php echo e($error); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Filter Form -->
        <?php if(auth()->user()->hasRole('Admin')): ?>
            <div class="mb-6 bg-gray-700 rounded-lg p-4 border border-gray-600">
                <h3 class="text-lg font-medium text-white mb-4">
                    <i class="fas fa-filter mr-2 text-blue-400"></i>
                    Filter Attendance Records
                </h3>
                <form method="GET" action="<?php echo e(route('attendance.index')); ?>">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div>
                            <label for="user_id" class="block text-sm font-medium text-gray-300 mb-2">Staff Member</label>
                            <select name="user_id" id="user_id" class="w-full bg-gray-600 border border-gray-500 text-white rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                                <option value="">All Staff</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>>
                                        <?php echo e($user->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div>
                            <label for="start_date" class="block text-sm font-medium text-gray-300 mb-2">Start Date</label>
                            <input type="date" name="start_date" id="start_date" class="w-full bg-gray-600 border border-gray-500 text-white rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent" value="<?php echo e(request('start_date')); ?>">
                        </div>
                        <div>
                            <label for="end_date" class="block text-sm font-medium text-gray-300 mb-2">End Date</label>
                            <input type="date" name="end_date" id="end_date" class="w-full bg-gray-600 border border-gray-500 text-white rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent" value="<?php echo e(request('end_date')); ?>">
                        </div>
                        <div class="flex items-end gap-2">
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                                <i class="fas fa-filter mr-2"></i>Filter
                            </button>
                            <a href="<?php echo e(route('attendance.index')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                                <i class="fas fa-times mr-2"></i>Clear
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        <?php endif; ?>

        <?php if($attendances->count() > 0): ?>
            <div class="bg-gray-700 rounded-lg border border-gray-600 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-800">
                            <tr>
                                <?php if(auth()->user()->hasRole('Admin')): ?>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Employee</th>
                                <?php endif; ?>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Day</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-600">
                            <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-gray-600 transition-colors duration-200">
                                    <?php if(auth()->user()->hasRole('Admin')): ?>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-white"><?php echo e($attendance->user->name); ?></td>
                                    <?php endif; ?>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300"><?php echo e($attendance->date->format('M d, Y')); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300"><?php echo e($attendance->date->format('l')); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            <?php echo e($attendance->status === 'present' ? 'bg-green-900 text-green-300' : 
                                               ($attendance->status === 'late' ? 'bg-yellow-900 text-yellow-300' : 
                                               ($attendance->status === 'absent' ? 'bg-red-900 text-red-300' : 'bg-blue-900 text-blue-300'))); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $attendance->status))); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex space-x-2">
                                            <a href="<?php echo e(route('attendance.show', $attendance)); ?>" class="text-blue-400 hover:text-blue-300 transition-colors duration-200">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $attendance)): ?>
                                                <a href="<?php echo e(route('attendance.edit', $attendance)); ?>" class="text-yellow-400 hover:text-yellow-300 transition-colors duration-200">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $attendance)): ?>
                                                <form action="<?php echo e(route('attendance.destroy', $attendance)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this attendance record?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="text-red-400 hover:text-red-300 transition-colors duration-200">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="mt-6 flex justify-center">
                <?php echo e($attendances->appends(request()->query())->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12 bg-gray-700 rounded-lg border border-gray-600">
                <i class="fas fa-calendar-times text-6xl text-gray-400 mb-4"></i>
                <h3 class="text-xl font-medium text-white mb-2">No attendance records found</h3>
                <p class="text-gray-400 mb-4">Start by checking in or adding attendance records.</p>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Attendance::class)): ?>
                    <a href="<?php echo e(route('attendance.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                        <i class="fas fa-plus mr-2"></i>Add First Record
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/attendance/index.blade.php ENDPATH**/ ?>