<?php $__env->startSection('page-title', 'Attendance Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl border border-gray-200 dark:border-gray-700">
    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-4 sm:mb-0">
                <i class="fas fa-calendar-check mr-3 text-red-500 dark:text-red-400"></i>
                Attendance Management
            </h1>
            <div class="flex flex-wrap gap-2">
                <?php if(auth()->user()->hasRole('Staff')): ?>
                    <form action="<?php echo e(route('attendance.checkin')); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-sign-in-alt mr-2"></i>Check In
                        </button>
                    </form>
                    <form action="<?php echo e(route('attendance.checkout')); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-yellow-600 hover:bg-yellow-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-sign-out-alt mr-2"></i>Check Out
                        </button>
                    </form>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Attendance::class)): ?>
                    <a href="<?php echo e(route('attendance.create')); ?>" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                        <i class="fas fa-plus mr-2"></i>Add Record
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="p-6">
        <?php if($errors->any()): ?>
            <div class="mb-4 bg-red-100 dark:bg-red-900 border border-red-200 dark:border-red-700 text-red-800 dark:text-red-300 px-4 py-3 rounded-md">
                <div class="flex items-center">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    <div>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div><?php echo e($error); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Filter Form -->
        <?php if(auth()->user()->hasRole('Admin')): ?>
            <div class="mb-6 bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-4">
                    <i class="fas fa-filter mr-2 text-red-500 dark:text-red-400"></i>
                    Filter Attendance Records
                </h3>
                <form method="GET" action="<?php echo e(route('attendance.index')); ?>">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div>
                            <label for="user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Staff Member</label>
                            <select name="user_id" id="user_id" class="w-full bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Staff</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>>
                                        <?php echo e($user->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div>
                            <label for="start_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Start Date</label>
                            <input type="date" name="start_date" id="start_date" class="w-full bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent" value="<?php echo e(request('start_date')); ?>">
                        </div>
                        <div>
                            <label for="end_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">End Date</label>
                            <input type="date" name="end_date" id="end_date" class="w-full bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent" value="<?php echo e(request('end_date')); ?>">
                        </div>
                        <div class="flex items-end gap-2">
                            <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                                <i class="fas fa-filter mr-2"></i>Filter
                            </button>
                            <a href="<?php echo e(route('attendance.index')); ?>" class="bg-gray-200 dark:bg-gray-600 hover:bg-gray-300 dark:hover:bg-gray-700 text-gray-700 dark:text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                                <i class="fas fa-times mr-2"></i>Clear
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        <?php endif; ?>

        <?php if($attendances->count() > 0): ?>
            <div class="bg-white dark:bg-gray-700 rounded-lg border border-gray-200 dark:border-gray-600 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 dark:bg-gray-800">
                            <tr>
                                <?php if(auth()->user()->hasRole('Admin')): ?>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Employee</th>
                                <?php endif; ?>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Day</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Type</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Photo</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Location</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-600">
                            <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-600 transition-colors duration-200">
                                    <?php if(auth()->user()->hasRole('Admin')): ?>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white"><?php echo e($attendance->user->name); ?></td>
                                    <?php endif; ?>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300"><?php echo e($attendance->date->format('M d, Y')); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300"><?php echo e($attendance->date->format('l')); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            <?php echo e($attendance->status === 'present' ? 'bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-300' : 
                                               ($attendance->status === 'late' ? 'bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-300' : 
                                               ($attendance->status === 'absent' ? 'bg-red-100 dark:bg-red-900 text-red-800 dark:text-red-300' : 'bg-orange-100 dark:bg-orange-900 text-orange-800 dark:text-orange-300'))); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $attendance->status))); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            <?php echo e($attendance->attendance_type === 'manual' ? 'bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-300' : 'bg-purple-100 dark:bg-purple-900 text-purple-800 dark:text-purple-300'); ?>">
                                            <?php echo e($attendance->attendance_type ? ucfirst($attendance->attendance_type) : 'Admin'); ?>

                                        </span>
                                        <?php if($attendance->hasSelfie()): ?>
                                            <i class="fas fa-camera ml-2 text-green-500 dark:text-green-400" title="Has Selfie"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php if($attendance->hasSelfie() && $attendance->attendance_type === 'check-in'): ?>
                                            <div class="flex items-center">
                                                <img src="<?php echo e($attendance->getSelfieUrl()); ?>" alt="Check-in Photo" 
                                                     class="w-12 h-12 rounded-lg object-cover border border-gray-200 dark:border-gray-600 cursor-pointer hover:scale-110 transition-transform duration-200"
                                                     onclick="openPhotoModal('<?php echo e($attendance->getSelfieUrl()); ?>', '<?php echo e($attendance->user->name); ?>', '<?php echo e($attendance->date->format('M d, Y g:i A')); ?>')">
                                            </div>
                                        <?php else: ?>
                                            <span class="text-gray-400 dark:text-gray-500 text-sm">No photo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                        <?php if($attendance->hasLocation()): ?>
                                            <div class="flex flex-col space-y-1">
                                                <div class="flex items-center">
                                                    <i class="fas fa-map-marker-alt text-red-500 dark:text-red-400 mr-1"></i>
                                                    <span class="truncate max-w-xs text-sm" title="<?php echo e($attendance->location_address ?: 'Location Available'); ?>">
                                                        <?php echo e(Str::limit($attendance->location_address ?: 'Location Available', 20)); ?>

                                                    </span>
                                                </div>
                                                <button onclick="openMapModal(<?php echo e($attendance->latitude); ?>, <?php echo e($attendance->longitude); ?>, '<?php echo e(addslashes($attendance->location_address ?: 'Location')); ?>')" 
                                                   class="text-xs text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-300 underline flex items-center">
                                                    <i class="fas fa-map-marker-alt mr-1"></i>
                                                    View on Map
                                                </button>
                                            </div>
                                        <?php else: ?>
                                            <span class="text-gray-400 dark:text-gray-500">No location</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex space-x-2">
                                            <a href="<?php echo e(route('attendance.show', $attendance)); ?>" class="text-blue-600 dark:text-red-400 hover:text-blue-800 dark:hover:text-red-300 transition-colors duration-200">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $attendance)): ?>
                                                <a href="<?php echo e(route('attendance.edit', $attendance)); ?>" class="text-yellow-600 dark:text-yellow-400 hover:text-yellow-800 dark:hover:text-yellow-300 transition-colors duration-200">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $attendance)): ?>
                                                <form action="<?php echo e(route('attendance.destroy', $attendance)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this attendance record?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-300 transition-colors duration-200">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="mt-6 flex justify-center">
                <?php echo e($attendances->appends(request()->query())->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12 bg-white dark:bg-gray-700 rounded-lg border border-gray-200 dark:border-gray-600">
                <i class="fas fa-calendar-times text-6xl text-gray-300 dark:text-gray-400 mb-4"></i>
                <h3 class="text-xl font-medium text-gray-900 dark:text-white mb-2">No attendance records found</h3>
                <p class="text-gray-500 dark:text-gray-400 mb-4">Start by checking in or adding attendance records.</p>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Attendance::class)): ?>
                    <a href="<?php echo e(route('attendance.create')); ?>" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                        <i class="fas fa-plus mr-2"></i>Add First Record
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Photo Modal -->
<div id="photoModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 hidden">
    <div class="bg-white dark:bg-gray-800 rounded-lg p-6 max-w-2xl max-h-screen overflow-auto border border-gray-200 dark:border-gray-600 shadow-xl">
        <div class="flex justify-between items-center mb-4">
            <div>
                <h3 id="modalTitle" class="text-lg font-medium text-gray-900 dark:text-white">Check-in Photo</h3>
                <p id="modalSubtitle" class="text-sm text-gray-500 dark:text-gray-400"></p>
            </div>
            <button onclick="closePhotoModal()" class="text-gray-400 hover:text-gray-500 dark:hover:text-white">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        <div class="text-center">
            <img id="modalImage" src="" alt="Check-in Photo" class="max-w-full max-h-96 rounded-lg border border-gray-200 dark:border-gray-600 shadow-md">
        </div>
    </div>
</div>

<!-- Map Modal -->
<div id="mapModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 hidden">
    <div class="bg-white dark:bg-gray-800 rounded-lg p-6 max-w-4xl w-full max-h-screen overflow-auto border border-gray-200 dark:border-gray-600 mx-4 shadow-xl">
        <div class="flex justify-between items-center mb-4">
            <div>
                <h3 id="mapModalTitle" class="text-lg font-medium text-gray-900 dark:text-white">Location</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">Interactive map view</p>
            </div>
            <button onclick="closeMapModal()" class="text-gray-400 hover:text-gray-500 dark:hover:text-white">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        <div class="w-full h-96 bg-gray-100 dark:bg-gray-700 rounded-lg">
            <iframe id="mapIframe" 
                    src="" 
                    width="100%" 
                    height="100%" 
                    style="border:0;" 
                    allowfullscreen="" 
                    loading="lazy" 
                    referrerpolicy="no-referrer-when-downgrade"
                    class="rounded-lg">
            </iframe>
        </div>
    </div>
</div>

<script>
function openPhotoModal(imageUrl, employeeName, dateTime) {
    document.getElementById('modalImage').src = imageUrl;
    document.getElementById('modalTitle').textContent = employeeName + ' - Check-in Photo';
    document.getElementById('modalSubtitle').textContent = 'Submitted on ' + dateTime;
    document.getElementById('photoModal').classList.remove('hidden');
}

function closePhotoModal() {
    document.getElementById('photoModal').classList.add('hidden');
}

// Close modal when clicking outside
document.getElementById('photoModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closePhotoModal();
    }
});

// Close map modal when clicking outside
document.getElementById('mapModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeMapModal();
    }
});

// Close modal with Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closePhotoModal();
        closeMapModal();
    }
});

// Map modal functions
function openMapModal(lat, lng, address) {
    const modal = document.getElementById('mapModal');
    const iframe = document.getElementById('mapIframe');
    const title = document.getElementById('mapModalTitle');
    
    // Set the title
    title.textContent = address || 'Location';
    
    // Set the Google Maps embed URL with marker
    iframe.src = `https://maps.google.com/maps?q=${lat},${lng}&hl=en&z=15&output=embed`;
    
    // Show the modal
    modal.classList.remove('hidden');
    document.body.style.overflow = 'hidden';
}

function closeMapModal() {
    const modal = document.getElementById('mapModal');
    const iframe = document.getElementById('mapIframe');
    
    // Hide the modal
    modal.classList.add('hidden');
    document.body.style.overflow = 'auto';
    
    // Clear the iframe src to stop loading
    iframe.src = '';
}
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\StaffApp\HRApp\resources\views/attendance/index.blade.php ENDPATH**/ ?>