<?php $__env->startSection('title', 'Stock Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-800 rounded-lg shadow-xl border border-gray-700">
    <div class="px-6 py-4 border-b border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-white mb-4 sm:mb-0">
                <i class="fas fa-boxes mr-3 text-red-400"></i>
                Stock Management
            </h1>
            <div class="flex items-center space-x-4">
                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                <a href="<?php echo e(route('stock.upload.form')); ?>" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                    <i class="fas fa-upload mr-2"></i>Upload Stock Data
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="p-6">
        <?php if(session('success')): ?>
            <div class="mb-6 bg-red-900 border border-red-700 text-red-300 px-4 py-3 rounded-md">
                <div class="flex items-center">
                    <i class="fas fa-check-circle mr-2"></i>
                    <div>
                        <strong class="font-bold">Success!</strong>
                        <span class="block sm:inline"><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Filters -->
        <div class="mb-6 bg-gray-700 rounded-lg p-4 border border-gray-600">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-white">
                    <i class="fas fa-filter mr-2 text-red-400"></i>
                    Filters
                </h3>
                <button type="button" id="toggleFilters" class="text-gray-400 hover:text-white transition-colors duration-200">
                    <i class="fas fa-chevron-down" id="filterIcon"></i>
                </button>
            </div>
            
            <div id="filterContent" class="space-y-4" style="display: block;">
                <form method="POST" action="<?php echo e(route('stock.index')); ?>" id="stockFilterForm">
                    <?php echo csrf_field(); ?>
                    <!-- Search Row -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                        <div>
                            <label for="search_name" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-search mr-1"></i>
                                Search Name
                            </label>
                            <input type="text" name="search_name" id="search_name" value="<?php echo e(request('search_name')); ?>" placeholder="Type to search names..."
                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="search_product" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-search mr-1"></i>
                                Search Product
                            </label>
                            <input type="text" name="search_product" id="search_product" value="<?php echo e(request('search_product')); ?>" placeholder="Type to search products..."
                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="search_style" class="block text-sm font-medium text-gray-300 mb-1">
                                <i class="fas fa-search mr-1"></i>
                                Search Style
                            </label>
                            <input type="text" name="search_style" id="search_style" value="<?php echo e(request('search_style')); ?>" placeholder="Type to search styles..."
                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                    </div>
                    
                    <!-- Filter Dropdowns Row -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-300 mb-1">Name</label>
                            <select name="name" id="name" class="w-full px-3 py-2 border border-gray-600 bg-gray-800 text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Names</option>
                                <?php $__currentLoopData = $filterData['names']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($name); ?>" <?php echo e(request('name') == $name ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div>
                            <label for="product" class="block text-sm font-medium text-gray-300 mb-1">Product</label>
                            <select name="product" id="product" class="w-full px-3 py-2 border border-gray-600 bg-gray-800 text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Products</option>
                                <?php $__currentLoopData = $filterData['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product); ?>" <?php echo e(request('product') == $product ? 'selected' : ''); ?>><?php echo e($product); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div>
                            <label for="style" class="block text-sm font-medium text-gray-300 mb-1">Style</label>
                            <select name="style" id="style" class="w-full px-3 py-2 border border-gray-600 bg-gray-800 text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Styles</option>
                                <?php $__currentLoopData = $filterData['styles']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $style): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($style); ?>" <?php echo e(request('style') == $style ? 'selected' : ''); ?>><?php echo e($style); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div>
                            <label for="color" class="block text-sm font-medium text-gray-300 mb-1">Color</label>
                            <select name="color" id="color" class="w-full px-3 py-2 border border-gray-600 bg-gray-800 text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Colors</option>
                                <?php $__currentLoopData = $filterData['colors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($color); ?>" <?php echo e(request('color') == $color ? 'selected' : ''); ?>><?php echo e($color); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div>
                            <label for="size" class="block text-sm font-medium text-gray-300 mb-1">Size</label>
                            <select name="size" id="size" class="w-full px-3 py-2 border border-gray-600 bg-gray-800 text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Sizes</option>
                                <?php $__currentLoopData = $filterData['sizes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($size); ?>" <?php echo e(request('size') == $size ? 'selected' : ''); ?>><?php echo e($size); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div>
                            <label for="batch_no" class="block text-sm font-medium text-gray-300 mb-1">Batch No</label>
                            <select name="batch_no" id="batch_no" class="w-full px-3 py-2 border border-gray-600 bg-gray-800 text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Batches</option>
                                <?php $__currentLoopData = $filterData['batchNos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batchNo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($batchNo); ?>" <?php echo e(request('batch_no') == $batchNo ? 'selected' : ''); ?>><?php echo e($batchNo); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- Action Buttons Row -->
                    <div class="mt-6 flex items-center justify-between">
                        <div class="flex space-x-3">
                            <button type="submit" id="searchButton" class="bg-red-600 hover:bg-red-700 text-white px-6 py-2 rounded-lg text-sm font-medium transition-colors duration-200 flex items-center">
                                <i class="fas fa-search mr-2"></i>Search
                            </button>
                            <button type="button" id="clearFiltersButton" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200 flex items-center">
                                <i class="fas fa-times mr-2"></i>Clear Filters
                            </button>
                        </div>
                        <div class="text-sm text-gray-400">
                            <i class="fas fa-info-circle mr-1"></i>
                            <span id="resultsCount">Showing <?php echo e($stocks->firstItem() ?? 0); ?> to <?php echo e($stocks->lastItem() ?? 0); ?> of <?php echo e($stocks->total()); ?> results</span>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Stock Table -->
        <div class="bg-gray-700 rounded-lg border border-gray-600 overflow-hidden">
            <?php echo $__env->make('stock.partials.table', ['stocks' => $stocks], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('Stock page JavaScript loaded - Traditional form submission enabled');
    
    // Toggle filter visibility
    const toggleButton = document.getElementById('toggleFilters');
    const filterContent = document.getElementById('filterContent');
    const filterIcon = document.getElementById('filterIcon');
    
    if (toggleButton && filterContent && filterIcon) {
        // Ensure filters are visible by default
        filterContent.style.display = 'block';
        filterIcon.classList.remove('fa-chevron-down');
        filterIcon.classList.add('fa-chevron-up');
        
        toggleButton.addEventListener('click', function() {
            if (filterContent.style.display === 'none') {
                filterContent.style.display = 'block';
                filterIcon.classList.remove('fa-chevron-down');
                filterIcon.classList.add('fa-chevron-up');
            } else {
                filterContent.style.display = 'none';
                filterIcon.classList.remove('fa-chevron-up');
                filterIcon.classList.add('fa-chevron-down');
            }
        });
    }
    
    // Handle clear filters button
    const clearFiltersBtn = document.getElementById('clearFiltersButton');
    if (clearFiltersBtn) {
        clearFiltersBtn.addEventListener('click', function(e) {
            e.preventDefault();
            console.log('Clear filters button clicked');
            
            // Clear all inputs and selects
            const form = document.getElementById('stockFilterForm');
            if (form) {
                form.reset();
                // Submit the form to show all results
                form.submit();
            }
        });
    }
    
    console.log('Traditional form submission mode - Search button will submit form to backend');
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\StaffApp\Nitin App\resources\views/stock/index.blade.php ENDPATH**/ ?>