<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Staff Management System'); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-gradient-to-br from-gray-900 via-red-900 to-orange-900 min-h-screen font-inter">
    <div id="app" class="min-h-screen">
        <?php if(auth()->guard()->check()): ?>
            <div class="flex h-screen bg-transparent">
                <!-- Mobile sidebar overlay -->
                <div class="fixed inset-0 z-40 md:hidden" id="mobile-sidebar-overlay" style="display: none;">
                    <div class="fixed inset-0 bg-gray-600 bg-opacity-75" onclick="toggleMobileSidebar()"></div>
                </div>

                <!-- Sidebar -->
                <div class="hidden md:flex md:w-64 md:flex-col" id="desktop-sidebar">
                    <div class="flex flex-col flex-grow pt-5 overflow-y-auto bg-gray-800 border-r border-gray-700">
                        <div class="flex items-center flex-shrink-0 px-4">
                            <h1 class="text-xl font-bold text-white">Staff Manager</h1>
                        </div>
                        <div class="mt-8 flex-grow flex flex-col">
                            <nav class="flex-1 px-2 pb-4 space-y-1">
                                <a href="<?php echo e(route('dashboard')); ?>" class="<?php echo e(request()->routeIs('dashboard') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-tachometer-alt mr-3 text-sm"></i>
                                    Dashboard
                                </a>
                                
                                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                                <a href="<?php echo e(route('staff.index')); ?>" class="<?php echo e(request()->routeIs('staff.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-users mr-3 text-sm"></i>
                                    Staff Management
                                </a>
                                <?php endif; ?>
                                
                                <a href="<?php echo e(route('tasks.index')); ?>" class="<?php echo e(request()->routeIs('tasks.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-tasks mr-3 text-sm"></i>
                                    Tasks
                                </a>
                                
                                <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                                <a href="<?php echo e(route('attendance.index')); ?>" class="<?php echo e(request()->routeIs('attendance.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-calendar-check mr-3 text-sm"></i>
                                    Attendance
                                </a>
                                
                                <a href="<?php echo e(route('payrolls.index')); ?>" class="<?php echo e(request()->routeIs('payrolls.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-money-bill-wave mr-3 text-sm"></i>
                                    Payroll
                                </a>
                                
                                <a href="<?php echo e(route('performance.index')); ?>" class="<?php echo e(request()->routeIs('performance.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-chart-line mr-3 text-sm"></i>
                                    Performance Analytics
                                </a>
                                
                                <a href="<?php echo e(route('stock.index')); ?>" class="<?php echo e(request()->routeIs('stock.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-boxes mr-3 text-sm"></i>
                                    Stock Management
                                </a>
                                <?php else: ?>
                                <a href="<?php echo e(route('attendance.staff')); ?>" class="<?php echo e(request()->routeIs('attendance.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium">
                                    <i class="fas fa-calendar-check mr-3 text-sm"></i>
                                    My Attendance
                                </a>
                                <?php endif; ?>
                            </nav>
                        </div>
                    </div>
                </div>

                <!-- Mobile sidebar -->
                <div class="fixed inset-y-0 left-0 z-50 w-64 bg-gray-800 transform -translate-x-full transition-transform duration-300 ease-in-out md:hidden" id="mobile-sidebar">
                    <div class="flex flex-col flex-grow pt-5 overflow-y-auto bg-gray-800 border-r border-gray-700">
                        <div class="flex items-center justify-between flex-shrink-0 px-4">
                            <h1 class="text-xl font-bold text-white">Staff Manager</h1>
                            <button type="button" class="md:hidden p-2 rounded-md text-gray-400 hover:text-gray-300 hover:bg-gray-700" onclick="toggleMobileSidebar()">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>

                        <nav class="flex-1 px-2 pb-4 space-y-1 mt-8">
                            <a href="<?php echo e(route('dashboard')); ?>" class="<?php echo e(request()->routeIs('dashboard') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-tachometer-alt mr-3 text-sm"></i>
                                Dashboard
                            </a>
                            
                            <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                            <a href="<?php echo e(route('staff.index')); ?>" class="<?php echo e(request()->routeIs('staff.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-users mr-3 text-sm"></i>
                                Staff Management
                            </a>
                            <?php endif; ?>
                            
                            <a href="<?php echo e(route('tasks.index')); ?>" class="<?php echo e(request()->routeIs('tasks.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-tasks mr-3 text-sm"></i>
                                Tasks
                            </a>
                            
                            <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                            <a href="<?php echo e(route('attendance.index')); ?>" class="<?php echo e(request()->routeIs('attendance.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-calendar-check mr-3 text-sm"></i>
                                Attendance
                            </a>
                            
                            <a href="<?php echo e(route('payrolls.index')); ?>" class="<?php echo e(request()->routeIs('payrolls.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-money-bill-wave mr-3 text-sm"></i>
                                Payroll
                            </a>
                            
                            <a href="<?php echo e(route('performance.index')); ?>" class="<?php echo e(request()->routeIs('performance.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-chart-line mr-3 text-sm"></i>
                                Performance Analytics
                            </a>
                            <?php endif; ?>
                            
                            <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
                            <a href="<?php echo e(route('payrolls.index')); ?>" class="<?php echo e(request()->routeIs('payrolls.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-money-bill-wave mr-3 text-sm"></i>
                                Payroll
                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(route('attendance.staff')); ?>" class="<?php echo e(request()->routeIs('attendance.*') ? 'bg-red-900 border-r-4 border-red-500 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white'); ?> group flex items-center px-2 py-2 text-sm font-medium" onclick="toggleMobileSidebar()">
                                <i class="fas fa-calendar-check mr-3 text-sm"></i>
                                My Attendance
                            </a>
                            <?php endif; ?>
                        </nav>
                    </div>
                </div>

                <!-- Main content -->
                <div class="flex flex-col flex-1 overflow-hidden">
                    <!-- Top navigation -->
                    <header class="bg-gray-800 shadow-sm border-b border-gray-700">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                            <div class="flex justify-between h-16">
                                <div class="flex items-center">
                                    <button type="button" class="md:hidden p-2 rounded-md text-gray-400 hover:text-gray-300 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-red-500" onclick="toggleMobileSidebar()">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <h2 class="ml-4 text-lg font-semibold text-white"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h2>
                                </div>
                                <div class="flex items-center space-x-4">
                                    <div class="relative">
                                        <button type="button" class="flex items-center text-sm rounded-full focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500" id="user-menu-button">
                                            <div class="h-8 w-8 rounded-full bg-gradient-to-r from-red-500 to-red-600 flex items-center justify-center">
                                                <span class="text-sm font-medium text-white"><?php echo e(substr(Auth::user()->name, 0, 1)); ?></span>
                                            </div>
                                            <span class="ml-3 text-white text-sm font-medium"><?php echo e(Auth::user()->name); ?></span>
                                            <i class="fas fa-chevron-down ml-2 text-xs text-gray-400"></i>
                                        </button>
                                        <div class="hidden absolute right-0 z-10 mt-2 w-48 origin-top-right rounded-md bg-gray-800 py-1 shadow-lg ring-1 ring-gray-700 ring-opacity-50" id="user-menu">
                                            <div class="px-4 py-2 text-xs text-gray-400 border-b border-gray-700">
                                                <?php echo e(Auth::user()->email); ?>

                                                <?php if(Auth::user()->hasRole('Admin')): ?>
                                                    <span class="block text-red-400 font-medium">Administrator</span>
                                                <?php else: ?>
                                                    <span class="block text-red-400 font-medium">Staff Member</span>
                                                <?php endif; ?>
                                            </div>
                                            <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 hover:text-white">
                                                <i class="fas fa-sign-out-alt mr-2"></i>Sign out
                                            </a>
                                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
                                                <?php echo csrf_field(); ?>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </header>

                    <!-- Page content -->
                    <main class="flex-1 overflow-y-auto bg-gray-900">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
                            <?php if(session('success')): ?>
                                <div class="mb-4 bg-green-900 border border-green-700 text-green-300 px-4 py-3 rounded-md">
                                    <i class="fas fa-check-circle mr-2"></i><?php echo e(session('success')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <?php if(session('error')): ?>
                                <div class="mb-4 bg-red-900 border border-red-700 text-red-300 px-4 py-3 rounded-md">
                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e(session('error')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                    </main>
                </div>
            </div>
        <?php else: ?>
            <!-- Guest layout -->
            <div class="min-h-screen bg-transparent flex flex-col justify-center py-12 sm:px-6 lg:px-8">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        <?php endif; ?>
    </div>

    <script>
        // Mobile sidebar toggle
        function toggleMobileSidebar() {
            const mobileSidebar = document.getElementById('mobile-sidebar');
            const overlay = document.getElementById('mobile-sidebar-overlay');
            
            if (mobileSidebar.classList.contains('-translate-x-full')) {
                // Show sidebar
                mobileSidebar.classList.remove('-translate-x-full');
                mobileSidebar.classList.add('translate-x-0');
                overlay.style.display = 'block';
            } else {
                // Hide sidebar
                mobileSidebar.classList.remove('translate-x-0');
                mobileSidebar.classList.add('-translate-x-full');
                overlay.style.display = 'none';
            }
        }

        // Simple dropdown toggle
        document.addEventListener('DOMContentLoaded', function() {
            const userMenuButton = document.getElementById('user-menu-button');
            const userMenu = document.getElementById('user-menu');
            
            if (userMenuButton && userMenu) {
                userMenuButton.addEventListener('click', function() {
                    userMenu.classList.toggle('hidden');
                });
                
                // Close dropdown when clicking outside
                document.addEventListener('click', function(event) {
                    if (!userMenuButton.contains(event.target) && !userMenu.contains(event.target)) {
                        userMenu.classList.add('hidden');
                    }
                });
            }
        });
    </script>
    
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\StaffApp\Nitin App\resources\views/layouts/app.blade.php ENDPATH**/ ?>