<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-white">Payroll Details</h1>
                        <p class="mt-1 text-sm text-gray-300"><?php echo e($payroll->user->name); ?> - <?php echo e(date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?></p>
                    </div>
                    <div class="flex space-x-3">
                        <a href="<?php echo e(route('payrolls.index')); ?>" class="inline-flex items-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to List
                        </a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $payroll)): ?>
                            <a href="<?php echo e(route('payrolls.edit', $payroll)); ?>" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                <i class="fas fa-edit mr-2"></i>
                                Edit
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Employee Information -->
            <div class="lg:col-span-2">
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mb-6">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Employee Information</h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Employee Name</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->user->name); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Employee ID</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->user->staffProfile->employee_id ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Department</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->user->staffProfile->department->name ?? 'No Department'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Position</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->user->staffProfile->position ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Email</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->user->email); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Phone</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->user->staffProfile->phone ?? 'N/A'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payroll Details -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-6">Payroll Breakdown</h3>
                        
                        <div class="space-y-6">
                            <!-- Basic Information -->
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Pay Period</label>
                                    <p class="mt-1 text-sm text-white"><?php echo e(date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?></p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Days Worked</label>
                                    <p class="mt-1 text-sm text-white"><?php echo e($payroll->days_worked ?? 0); ?> days</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Days Present</label>
                                    <p class="mt-1 text-sm text-white"><?php echo e($payroll->days_present ?? 0); ?> days</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Days Absent</label>
                                    <p class="mt-1 text-sm text-white"><?php echo e($payroll->days_absent ?? 0); ?> days</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Total Work Days</label>
                                    <p class="mt-1 text-sm text-white"><?php echo e($payroll->total_work_days ?? 0); ?> days</p>
                                </div>
                            </div>

                            <!-- Earnings -->
                            <div>
                                <h4 class="text-md font-medium text-white mb-4">Earnings</h4>
                                <div class="bg-gray-700 p-4 rounded-md border border-gray-600">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-300">Monthly Compensation:</span>
                                            <span class="text-sm font-medium text-white">₹<?php echo e(number_format($payroll->monthly_compensation, 2)); ?></span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-300">Daily Rate:</span>
                                            <span class="text-sm font-medium text-white">₹<?php echo e(number_format($payroll->daily_rate ?? 0, 2)); ?></span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span class="text-sm text-gray-300">Total Payout:</span>
                                            <span class="text-sm font-medium text-white">₹<?php echo e(number_format($payroll->total_payout ?? 0, 2)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>


                                      

                            <!-- Deductions -->
                            <?php if($payroll->deductions > 0): ?>
                            <div>
                                <h4 class="text-md font-medium text-white mb-4">Deductions</h4>
                                <div class="bg-red-900 bg-opacity-20 p-4 rounded-md border border-red-700">
                                    <div class="flex justify-between">
                                        <span class="text-sm text-gray-300">Total Deductions:</span>
                                        <span class="text-sm font-medium text-red-400">-₹<?php echo e(number_format($payroll->deductions, 2)); ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>


                        </div>
                    </div>
                </div>
            </div>

            <!-- Status & Actions -->
            <div class="space-y-6">
                <!-- Status Card -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Status</h3>
                        
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Current Status</label>
                                <span class="mt-1 inline-flex px-3 py-1 text-sm font-semibold rounded-full
                                    <?php if($payroll->status === 'paid'): ?> bg-green-900 text-green-200
                                    <?php elseif($payroll->status === 'approved'): ?> bg-yellow-900 text-yellow-200
                                    <?php else: ?> bg-gray-700 text-gray-200 <?php endif; ?>">
                                    <?php echo e(ucfirst($payroll->status)); ?>

                                </span>
                            </div>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $payroll)): ?>
                                <?php if($payroll->status === 'pending'): ?>
                                    <form action="<?php echo e(route('payrolls.approve', $payroll)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                                            <i class="fas fa-check mr-2"></i>
                                            Approve Payroll
                                        </button>
                                    </form>
                                <?php endif; ?>
                                
                                <?php if($payroll->status === 'approved'): ?>
                                    <form action="<?php echo e(route('payrolls.markPaid', $payroll)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                            <i class="fas fa-money-bill-wave mr-2"></i>
                                            Mark as Paid
                                        </button>
                                    </form>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Quick Actions</h3>
                        
                        <div class="space-y-3">
                            <a href="<?php echo e(route('staff.show', $payroll->user)); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                <i class="fas fa-user mr-2"></i>
                                View Employee
                            </a>
                            <a href="<?php echo e(route('attendance.index', ['user_id' => $payroll->user->id, 'month' => $payroll->month, 'year' => $payroll->year])); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                <i class="fas fa-calendar-check mr-2"></i>
                                View Attendance
                            </a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Payroll::class)): ?>
                                <a href="<?php echo e(route('payrolls.create', ['user_id' => $payroll->user->id])); ?>" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                    <i class="fas fa-plus mr-2"></i>
                                    Create New Payroll
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Timestamps -->
                <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-4 mb-4">Record Information</h3>
                        
                        <div class="space-y-3">
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Created At</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->created_at->format('M j, Y g:i A')); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Last Updated</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->updated_at->format('M j, Y g:i A')); ?></p>
                            </div>
                            <?php if($payroll->status === 'paid' && $payroll->paid_at): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Paid At</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($payroll->paid_at->format('M j, Y g:i A')); ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/payroll/show.blade.php ENDPATH**/ ?>