<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-white">Edit Attendance Record</h1>
                        <p class="mt-1 text-sm text-gray-300">Update attendance information for <?php echo e($attendance->user->name); ?></p>
                    </div>
                    <a href="<?php echo e(route('attendance.index')); ?>" class="inline-flex items-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>

        <!-- Error Messages -->
        <?php if($errors->any()): ?>
            <div class="bg-red-800 border border-red-700 text-red-200 px-4 py-3 rounded-lg mb-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-circle"></i>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium">There were some errors with your submission:</h3>
                        <ul class="mt-2 text-sm list-disc list-inside">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Edit Form -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
            <form action="<?php echo e(route('attendance.update', $attendance)); ?>" method="POST" class="px-4 py-5 sm:p-6">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <!-- Hidden user_id field -->
                <input type="hidden" name="user_id" value="<?php echo e($attendance->user_id); ?>">

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Employee Information (Read-only) -->
                    <div class="space-y-4">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-2">Employee Information</h3>
                        <div>
                            <label class="block text-sm font-medium text-gray-300">Employee Name</label>
                            <p class="mt-1 text-sm text-white bg-gray-700 p-3 rounded-md border border-gray-600"><?php echo e($attendance->user->name); ?></p>
                        </div>
                        <?php if($attendance->user->staffProfile): ?>
                        <div>
                            <label class="block text-sm font-medium text-gray-300">Department</label>
                            <p class="mt-1 text-sm text-white bg-gray-700 p-3 rounded-md border border-gray-600"><?php echo e($attendance->user->staffProfile->department->name ?? 'N/A'); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Attendance Details -->
                    <div class="space-y-4">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-2">Attendance Details</h3>
                        
                        <!-- Date -->
                        <div>
                            <label for="date" class="block text-sm font-medium text-gray-300">Date <span class="text-red-400">*</span></label>
                            <input type="date" name="date" id="date" value="<?php echo e(old('date', $attendance->date->format('Y-m-d'))); ?>" required
                                class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                            <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Status -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-300">Status <span class="text-red-400">*</span></label>
                            <select name="status" id="status" required
                                class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent">
                                <option value="present" <?php echo e(old('status', $attendance->status) === 'present' ? 'selected' : ''); ?>>Present</option>
                                <option value="absent" <?php echo e(old('status', $attendance->status) === 'absent' ? 'selected' : ''); ?>>Absent</option>
                                <option value="late" <?php echo e(old('status', $attendance->status) === 'late' ? 'selected' : ''); ?>>Late</option>
                                <option value="half_day" <?php echo e(old('status', $attendance->status) === 'half_day' ? 'selected' : ''); ?>>Half Day</option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>



                <!-- Notes -->
                <div class="mt-6">
                    <label for="notes" class="block text-sm font-medium text-gray-300">Notes</label>
                    <textarea name="notes" id="notes" rows="3" placeholder="Add any additional notes about this attendance record..."
                        class="mt-1 block w-full bg-gray-700 border border-gray-600 rounded-md shadow-sm py-2 px-3 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"><?php echo e(old('notes', $attendance->notes)); ?></textarea>
                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Form Actions -->
                <div class="mt-6 flex items-center justify-end space-x-3 pt-6 border-t border-gray-700">
                    <a href="<?php echo e(route('attendance.show', $attendance)); ?>" class="inline-flex items-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                        Cancel
                    </a>
                    <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                        <i class="fas fa-save mr-2"></i>
                        Update Attendance
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/attendance/edit.blade.php ENDPATH**/ ?>