<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-white">Attendance Details</h1>
                        <p class="mt-1 text-sm text-gray-300">View attendance record information</p>
                    </div>
                    <div class="flex space-x-3">
                        <a href="<?php echo e(route('attendance.index')); ?>" class="inline-flex items-center px-4 py-2 border border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-300 bg-gray-700 hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Back to List
                        </a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $attendance)): ?>
                            <a href="<?php echo e(route('attendance.edit', $attendance)); ?>" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                <i class="fas fa-edit mr-2"></i>
                                Edit
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Attendance Details -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700">
            <div class="px-4 py-5 sm:p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Employee Information -->
                    <?php if(auth()->user()->hasRole('Admin')): ?>
                    <div class="space-y-4">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-2">Employee Information</h3>
                        <div class="space-y-3">
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Name</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($attendance->user->name); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Email</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($attendance->user->email); ?></p>
                            </div>
                            <?php if($attendance->user->staffProfile): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Department</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($attendance->user->staffProfile->department->name ?? 'N/A'); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Position</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($attendance->user->staffProfile->position ?? 'N/A'); ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Attendance Information -->
                    <div class="space-y-4">
                        <h3 class="text-lg font-medium text-white border-b border-gray-700 pb-2">Attendance Information</h3>
                        <div class="space-y-3">
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Date</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($attendance->date->format('l, F j, Y')); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Status</label>
                                <span class="mt-1 inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                    <?php if($attendance->status === 'present'): ?> bg-green-100 text-green-800
                                    <?php elseif($attendance->status === 'absent'): ?> bg-red-100 text-red-800
                                    <?php elseif($attendance->status === 'late'): ?> bg-yellow-100 text-yellow-800
                                    <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                                    <?php echo e(ucfirst($attendance->status)); ?>

                                </span>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Day of Week</label>
                                <p class="mt-1 text-sm text-white"><?php echo e($attendance->date->format('l')); ?></p>
                            </div>
                            <?php if($attendance->notes): ?>
                            <div>
                                <label class="block text-sm font-medium text-gray-300">Notes</label>
                                <p class="mt-1 text-sm text-white bg-gray-700 p-3 rounded-md border border-gray-600"><?php echo e($attendance->notes); ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Timestamps -->
                <div class="mt-6 pt-6 border-t border-gray-700">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-300">Created At</label>
                            <p class="mt-1 text-sm text-white"><?php echo e($attendance->created_at->format('M j, Y g:i A')); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300">Last Updated</label>
                            <p class="mt-1 text-sm text-white"><?php echo e($attendance->updated_at->format('M j, Y g:i A')); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Attendance Calendar -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700 mt-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-bold text-white">
                        <i class="fas fa-calendar-alt mr-2 text-green-400"></i>
                        <?php echo e($attendance->user->name); ?>'s Attendance Calendar
                    </h2>
                    
                    <!-- Month Navigation -->
                    <div class="flex items-center space-x-4">
                        <a href="<?php echo e(route('attendance.show', array_merge(['attendance' => $attendance->id], ['month' => $month == 1 ? 12 : $month - 1, 'year' => $month == 1 ? $year - 1 : $year]))); ?>" 
                           class="bg-gray-700 hover:bg-gray-600 text-white px-3 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-chevron-left"></i>
                        </a>
                        
                        <div class="flex items-center space-x-2">
                            <select onchange="navigateToMonth(this.value, <?php echo e($year); ?>)" class="bg-gray-700 border border-gray-600 text-white rounded-md px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-green-500">
                                <?php for($m = 1; $m <= 12; $m++): ?>
                                    <option value="<?php echo e($m); ?>" <?php echo e($m == $month ? 'selected' : ''); ?>>
                                        <?php echo e(DateTime::createFromFormat('!m', $m)->format('F')); ?>

                                    </option>
                                <?php endfor; ?>
                            </select>
                            
                            <select onchange="navigateToMonth(<?php echo e($month); ?>, this.value)" class="bg-gray-700 border border-gray-600 text-white rounded-md px-3 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-green-500">
                                <?php for($y = 2020; $y <= 2030; $y++): ?>
                                    <option value="<?php echo e($y); ?>" <?php echo e($y == $year ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        
                        <a href="<?php echo e(route('attendance.show', array_merge(['attendance' => $attendance->id], ['month' => $month == 12 ? 1 : $month + 1, 'year' => $month == 12 ? $year + 1 : $year]))); ?>" 
                           class="bg-gray-700 hover:bg-gray-600 text-white px-3 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-chevron-right"></i>
                        </a>
                    </div>
                </div>

                <!-- Summary Statistics -->
                <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-6">
                    <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                        <div class="text-2xl font-bold text-blue-400"><?php echo e($summary['total_working_days']); ?></div>
                        <div class="text-sm text-gray-300">Working Days</div>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                        <div class="text-2xl font-bold text-green-400"><?php echo e($summary['present_days']); ?></div>
                        <div class="text-sm text-gray-300">Present</div>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                        <div class="text-2xl font-bold text-yellow-400"><?php echo e($summary['late_days']); ?></div>
                        <div class="text-sm text-gray-300">Late</div>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                        <div class="text-2xl font-bold text-red-400"><?php echo e($summary['absent_days']); ?></div>
                        <div class="text-sm text-gray-300">Absent</div>
                    </div>
                    <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                        <div class="text-2xl font-bold text-green-400"><?php echo e($summary['attendance_percentage']); ?>%</div>
                        <div class="text-sm text-gray-300">Attendance</div>
                    </div>
                </div>

                <!-- Calendar Grid -->
                <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                    <div class="grid grid-cols-7 gap-1 mb-4">
                        <div class="text-center text-sm font-medium text-gray-300 py-2">Sun</div>
                        <div class="text-center text-sm font-medium text-gray-300 py-2">Mon</div>
                        <div class="text-center text-sm font-medium text-gray-300 py-2">Tue</div>
                        <div class="text-center text-sm font-medium text-gray-300 py-2">Wed</div>
                        <div class="text-center text-sm font-medium text-gray-300 py-2">Thu</div>
                        <div class="text-center text-sm font-medium text-gray-300 py-2">Fri</div>
                        <div class="text-center text-sm font-medium text-gray-300 py-2">Sat</div>
                    </div>
                    
                    <div class="grid grid-cols-7 gap-1">
                        <?php $__currentLoopData = $calendarData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($day === null): ?>
                                <div class="h-12"></div>
                            <?php else: ?>
                                <div class="h-12 flex items-center justify-center text-sm rounded-md border 
                                    <?php if($day['is_weekend']): ?> 
                                        bg-blue-900 border-blue-700 text-blue-300
                                    <?php elseif($day['attendance']): ?>
                                        <?php if($day['attendance']->status === 'present'): ?> bg-green-900 border-green-700 text-green-300
                                        <?php elseif($day['attendance']->status === 'late'): ?> bg-yellow-900 border-yellow-700 text-yellow-300
                                        <?php elseif($day['attendance']->status === 'absent'): ?> bg-red-900 border-red-700 text-red-300
                                        <?php else: ?> bg-gray-600 border-gray-500 text-gray-300 <?php endif; ?>
                                    <?php else: ?> 
                                        bg-gray-600 border-gray-500 text-gray-300
                                    <?php endif; ?>
                                    <?php if($day['is_today']): ?> ring-2 ring-green-400 <?php endif; ?>"
                                    title="<?php if($day['attendance']): ?> <?php echo e(ucfirst($day['attendance']->status)); ?> <?php elseif($day['is_weekend']): ?> Holiday <?php else: ?> No Record <?php endif; ?>">
                                    <?php echo e($day['day']); ?>

                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <!-- Legend -->
                    <div class="mt-4 flex flex-wrap gap-4 text-sm">
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-green-900 border border-green-700 rounded mr-2"></div>
                            <span class="text-gray-300">Present</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-yellow-900 border border-yellow-700 rounded mr-2"></div>
                            <span class="text-gray-300">Late</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-red-900 border border-red-700 rounded mr-2"></div>
                            <span class="text-gray-300">Absent</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-blue-900 border border-blue-700 rounded mr-2"></div>
                            <span class="text-gray-300">Holiday</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-4 h-4 bg-gray-600 border border-gray-500 rounded mr-2"></div>
                            <span class="text-gray-300">No Record</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function navigateToMonth(month, year) {
    window.location.href = `<?php echo e(route('attendance.show', $attendance->id)); ?>?month=${month}&year=${year}`;
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/attendance/show.blade.php ENDPATH**/ ?>