<?php $__env->startSection('page-title', 'Assignment History'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gray-800 rounded-lg shadow-xl border border-gray-700">
    <div class="px-6 py-4 border-b border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-white mb-4 sm:mb-0">
                <i class="fas fa-history mr-3 text-purple-400"></i>
                Assignment History - <?php echo e($task->title); ?>

            </h1>
            <a href="<?php echo e(route('tasks.show', $task)); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>Back to Task
            </a>
        </div>
    </div>

    <div class="p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                <h3 class="text-lg font-medium text-white mb-4 border-b border-gray-600 pb-2">
                    <i class="fas fa-info-circle mr-2 text-blue-400"></i>Task Details
                </h3>
                <div class="space-y-2">
                    <p class="text-sm text-gray-300"><span class="font-medium text-white">Title:</span> <?php echo e($task->title); ?></p>
                    <p class="text-sm text-gray-300"><span class="font-medium text-white">Created by:</span> <?php echo e($task->creator->name); ?></p>
                    <p class="text-sm text-gray-300">
                        <span class="font-medium text-white">Current Status:</span>
                        <?php if($task->status === 'completed'): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-900 text-green-300">
                                <i class="fas fa-check mr-1"></i><?php echo e(ucfirst($task->status)); ?>

                            </span>
                        <?php elseif($task->status === 'in_progress'): ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-900 text-yellow-300">
                                <i class="fas fa-clock mr-1"></i><?php echo e(ucfirst(str_replace('_', ' ', $task->status))); ?>

                            </span>
                        <?php else: ?>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-900 text-gray-300">
                                <i class="fas fa-pause mr-1"></i><?php echo e(ucfirst($task->status)); ?>

                            </span>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                <?php if($task->currentAssignment): ?>
                <h3 class="text-lg font-medium text-white mb-4 border-b border-gray-600 pb-2">
                    <i class="fas fa-user-check mr-2 text-green-400"></i>Current Assignment
                </h3>
                <div class="space-y-2">
                    <p class="text-sm text-gray-300"><span class="font-medium text-white">Assigned to:</span> <?php echo e($task->currentAssignment->assignedTo->name); ?></p>
                    <p class="text-sm text-gray-300"><span class="font-medium text-white">Assigned by:</span> <?php echo e($task->currentAssignment->assignedBy->name); ?></p>
                    <p class="text-sm text-gray-300"><span class="font-medium text-white">Assigned on:</span> <?php echo e($task->currentAssignment->assigned_at->format('M d, Y H:i')); ?></p>
                </div>
                <?php else: ?>
                <h3 class="text-lg font-medium text-white mb-4 border-b border-gray-600 pb-2">
                    <i class="fas fa-user-times mr-2 text-red-400"></i>Current Assignment
                </h3>
                <p class="text-sm text-gray-400">No current assignment</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="bg-gray-700 rounded-lg border border-gray-600">
            <div class="px-6 py-4 border-b border-gray-600">
                <h3 class="text-lg font-medium text-white">
                    <i class="fas fa-timeline mr-2 text-purple-400"></i>Assignment Timeline
                </h3>
            </div>
            <div class="p-6">
                <div class="flow-root">
                    <ul class="-mb-8">
                        <?php $__empty_1 = true; $__currentLoopData = $task->assignments->sortBy('assigned_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li>
                            <div class="relative pb-8">
                                <?php if(!$loop->last): ?>
                                <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-600" aria-hidden="true"></span>
                                <?php endif; ?>
                                <div class="relative flex space-x-3">
                                    <div>
                                        <?php if($assignment->status === 'completed'): ?>
                                        <span class="h-8 w-8 rounded-full bg-green-500 flex items-center justify-center ring-8 ring-gray-800">
                                            <i class="fas fa-check text-white text-xs"></i>
                                        </span>
                                        <?php elseif($assignment->status === 'active'): ?>
                                        <span class="h-8 w-8 rounded-full bg-blue-500 flex items-center justify-center ring-8 ring-gray-800">
                                            <i class="fas fa-user text-white text-xs"></i>
                                        </span>
                                        <?php else: ?>
                                        <span class="h-8 w-8 rounded-full bg-gray-500 flex items-center justify-center ring-8 ring-gray-800">
                                            <i class="fas fa-arrow-right text-white text-xs"></i>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="min-w-0 flex-1">
                                        <div class="bg-gray-600 rounded-lg p-4 border border-gray-500">
                                            <div class="flex items-start justify-between">
                                                <div class="flex-1">
                                                    <div class="flex items-center space-x-2 mb-2">
                                                        <span class="text-sm font-medium text-white">
                                                            <strong><?php echo e($assignment->assignedBy->name); ?></strong> assigned task to 
                                                            <strong><?php echo e($assignment->assignedTo->name); ?></strong>
                                                        </span>
                                                    </div>
                                                    <?php if($assignment->department): ?>
                                                    <p class="text-xs text-gray-400 mb-1">Department: <?php echo e($assignment->department->name); ?></p>
                                                    <?php endif; ?>
                                                    <?php if($assignment->notes): ?>
                                                        <p class="text-sm text-gray-300 italic">"<?php echo e($assignment->notes); ?>"</p>
                                                    <?php endif; ?>
                                                    <div class="mt-2 text-xs text-gray-400">
                                                        <span><i class="fas fa-calendar mr-1"></i><?php echo e($assignment->assigned_at->format('M d, Y H:i')); ?></span>
                                                        <?php if($assignment->completed_at): ?>
                                                            <span class="ml-4"><i class="fas fa-check-circle mr-1"></i>Completed: <?php echo e($assignment->completed_at->format('M d, Y H:i')); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="ml-4">
                                                    <?php if($assignment->status === 'completed'): ?>
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-900 text-green-300">
                                                            <i class="fas fa-check mr-1"></i><?php echo e(ucfirst($assignment->status)); ?>

                                                        </span>
                                                    <?php elseif($assignment->status === 'active'): ?>
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-900 text-blue-300">
                                                            <i class="fas fa-clock mr-1"></i><?php echo e(ucfirst($assignment->status)); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-900 text-gray-300">
                                                            <i class="fas fa-pause mr-1"></i><?php echo e(ucfirst($assignment->status)); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li>
                            <div class="text-center py-12">
                                <i class="fas fa-history text-6xl text-gray-500 mb-4"></i>
                                <h3 class="text-xl font-medium text-gray-300 mb-2">No assignment history</h3>
                                <p class="text-gray-400">This task has no assignment history yet.</p>
                            </div>
                        </li>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\kisha\Desktop\Nitin App\resources\views/tasks/assignment-history.blade.php ENDPATH**/ ?>