@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-transparent py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Task Details</h1>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300">View task information and progress</p>
                    </div>
                    <div class="flex space-x-3">
                            <a href="{{ route('tasks.index') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                <i class="fas fa-arrow-left mr-2"></i>
                                Back to List
                            </a>
                            @can('viewAssignmentHistory', $task)
                                <a href="{{ route('tasks.assignment-history', $task) }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                    <i class="fas fa-history mr-2"></i>
                                    Assignment History
                                </a>
                            @endcan
                            @can('update', $task)
                                <a href="{{ route('tasks.edit', $task) }}" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                                    <i class="fas fa-edit mr-2"></i>
                                    Edit
                                </a>
                            @endcan
                        </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Task Information -->
            <div class="lg:col-span-2">
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <div class="flex items-start justify-between mb-6">
                            <div>
                                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">{{ $task->title }}</h3>
                                <div class="mt-2 flex items-center space-x-4">
                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                        @if($task->status === 'completed') bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300
                                        @elseif($task->status === 'in_progress') bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300
                                        @elseif($task->status === 'cancelled') bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300
                                        @elseif($task->status === 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300
                                        @else bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300 @endif">
                                        {{ ucfirst(str_replace('_', ' ', $task->status)) }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Task Description -->
                        @if($task->description)
                        <div class="mb-6">
                            <h4 class="text-md font-medium text-gray-900 dark:text-white mb-3">Description</h4>
                            <div class="bg-gray-50 dark:bg-gray-700/50 p-4 rounded-md border border-gray-200 dark:border-gray-600">
                                <p class="text-sm text-gray-700 dark:text-gray-300 whitespace-pre-wrap">{{ $task->description }}</p>
                            </div>
                        </div>
                        @endif

                        <!-- Task Details -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Created By</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $task->creator->name }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Assigned To</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $task->currentAssignee->name ?? 'Unassigned' }}</p>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Department</label>
                                <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $task->currentDepartment->name ?? 'No Department' }}</p>
                            </div>

                        </div>

                        <!-- Parent Task & Subtasks -->
                        @if($task->parent_id || $task->subtasks->count() > 0)
                        <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                            <h4 class="text-md font-medium text-gray-900 dark:text-white mb-4">
                                <i class="fas fa-sitemap mr-2 text-red-500 dark:text-red-400"></i>
                                Task Hierarchy
                            </h4>
                            
                            @if($task->parent_id)
                            <!-- Parent Task -->
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300 mb-2">
                                    <i class="fas fa-arrow-up mr-1 text-green-500 dark:text-green-400"></i>
                                    Parent Task
                                </label>
                                <div class="bg-gray-50 dark:bg-gray-700/50 p-3 rounded-md border border-gray-200 dark:border-gray-600">
                                    <a href="{{ route('tasks.show', $task->parent) }}" class="text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 font-medium">
                                        {{ $task->parent->title }}
                                    </a>
                                    <span class="ml-2 inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                        {{ $task->parent->status === 'completed' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300' : 
                                        ($task->parent->status === 'in_progress' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300' : 
                                        ($task->parent->status === 'cancelled' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300' : 
                                        ($task->parent->status === 'pending' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300'))) }}">
                                        {{ ucfirst(str_replace('_', ' ', $task->parent->status)) }}
                                    </span>
                                </div>
                            </div>
                            @endif
                            
                            @if($task->subtasks->count() > 0)
                            <!-- Subtasks -->
                            <div>
                                <label class="block text-sm font-medium text-gray-500 dark:text-gray-300 mb-2">
                                    <i class="fas fa-arrow-down mr-1 text-red-500 dark:text-red-400"></i>
                                    Subtasks ({{ $task->subtasks->count() }})
                                    @if($task->isParentTask())
                                        <span class="ml-2 text-xs text-gray-500 dark:text-gray-400">
                                            {{ $task->getSubtaskCompletionPercentage() }}% Complete
                                        </span>
                                    @endif
                                </label>
                                <div class="space-y-2">
                                    @foreach($task->subtasks as $subtask)
                                    <div class="bg-gray-50 dark:bg-gray-700/50 p-3 rounded-md border border-gray-200 dark:border-gray-600 flex items-center justify-between">
                                        <div class="flex items-center">
                                            <i class="fas fa-tasks text-red-500 dark:text-red-400 mr-2"></i>
                                            <a href="{{ route('tasks.show', $subtask) }}" class="text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300">
                                                {{ $subtask->title }}
                                            </a>
                                        </div>
                                        <div class="flex items-center space-x-2">
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                {{ $subtask->priority === 'urgent' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300' :
                            ($subtask->priority === 'high' ? 'bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300' :
                            ($subtask->priority === 'medium' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300' : 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300')) }}">
                                                {{ ucfirst($subtask->priority) }}
                                            </span>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                {{ $subtask->status === 'completed' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300' : 
                                                ($subtask->status === 'in_progress' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300' : 
                                                ($subtask->status === 'cancelled' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300' : 
                                                ($subtask->status === 'pending' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300'))) }}">
                                                {{ ucfirst(str_replace('_', ' ', $subtask->status)) }}
                                            </span>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                
                                @can('create', App\Models\Task::class)
                                <div class="mt-3">
                                    <a href="{{ route('tasks.create', ['parent_id' => $task->id]) }}" 
                                       class="inline-flex items-center px-3 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-md transition-colors duration-200">
                                        <i class="fas fa-plus mr-2"></i>
                                        Add Subtask
                                    </a>
                                </div>
                                @endcan
                            </div>
                            @endif
                        </div>
                        @endif

                        <!-- Timestamps -->
                        <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Created At</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $task->created_at->format('M j, Y g:i A') }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-500 dark:text-gray-300">Last Updated</label>
                                    <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $task->updated_at->format('M j, Y g:i A') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Task Timeline -->
                <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mt-6">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Task Timeline</h3>
                        
                        <div class="flow-root">
                            <ul class="-mb-8">
                                <!-- Task Creation -->
                                <li>
                                    <div class="relative pb-8">
                                        <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-200 dark:bg-gray-600" aria-hidden="true"></span>
                                        <div class="relative flex space-x-3">
                                            <div>
                                                <span class="h-8 w-8 rounded-full bg-red-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                                    <i class="fas fa-plus text-white text-xs"></i>
                                                </span>
                                            </div>
                                            <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                                <div>
                                                    <p class="text-sm text-gray-900 dark:text-white">Task created by <span class="font-medium">{{ $task->creator->name }}</span></p>
                                                    <p class="text-xs text-gray-500 dark:text-gray-400">{{ $task->created_at->format('M j, Y g:i A') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                
                                <!-- Assignment History -->
                                @forelse($task->assignments->sortBy('assigned_at') as $assignment)
                                    <li>
                                        <div class="relative pb-8">
                                            @if(!$loop->last)
                                                <span class="absolute top-4 left-4 -ml-px h-full w-0.5 bg-gray-200 dark:bg-gray-600" aria-hidden="true"></span>
                                            @endif
                                            <div class="relative flex space-x-3">
                                                <div>
                                                    @if($assignment->status === 'completed')
                                                        <span class="h-8 w-8 rounded-full bg-green-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                                            <i class="fas fa-check text-white text-xs"></i>
                                                        </span>
                                                    @elseif($assignment->status === 'reassigned')
                                                        <span class="h-8 w-8 rounded-full bg-yellow-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                                            <i class="fas fa-exchange-alt text-white text-xs"></i>
                                                        </span>
                                                    @else
                                                        <span class="h-8 w-8 rounded-full bg-red-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                                            <i class="fas fa-user text-white text-xs"></i>
                                                        </span>
                                                    @endif
                                                </div>
                                                <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                                    <div>
                                                        @if($assignment->status === 'completed')
                                                            <p class="text-sm text-gray-900 dark:text-white">Task completed by <span class="font-medium">{{ $assignment->assignedTo->name }}</span></p>
                                                            @if($assignment->completed_at)
                                                                <p class="text-xs text-gray-500 dark:text-gray-400">{{ $assignment->completed_at->format('M j, Y g:i A') }}</p>
                                                            @endif
                                                        @elseif($assignment->status === 'reassigned')
                                                            <p class="text-sm text-gray-900 dark:text-white">Task reassigned from <span class="font-medium">{{ $assignment->assignedTo->name }}</span> by <span class="font-medium">{{ $assignment->assignedBy->name }}</span></p>
                                                            <p class="text-xs text-gray-500 dark:text-gray-400">{{ $assignment->assigned_at->format('M j, Y g:i A') }}</p>
                                                        @else
                                                            <p class="text-sm text-gray-900 dark:text-white">Task assigned to <span class="font-medium">{{ $assignment->assignedTo->name }}</span> by <span class="font-medium">{{ $assignment->assignedBy->name }}</span></p>
                                                            <p class="text-xs text-gray-500 dark:text-gray-400">{{ $assignment->assigned_at->format('M j, Y g:i A') }}</p>
                                                        @endif
                                                        
                                                        @if($assignment->department)
                                                            <p class="text-xs text-gray-500 dark:text-gray-500">Department: {{ $assignment->department->name }}</p>
                                                        @endif
                                                        
                                                        @if($assignment->notes)
                                                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1 italic">"{{ $assignment->notes }}"</p>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @empty
                                    <li>
                                        <div class="relative pb-8">
                                            <div class="relative flex space-x-3">
                                                <div>
                                                    <span class="h-8 w-8 rounded-full bg-gray-400 dark:bg-gray-500 flex items-center justify-center ring-8 ring-white dark:ring-gray-800">
                                                        <i class="fas fa-clock text-white text-xs"></i>
                                                    </span>
                                                </div>
                                                <div class="min-w-0 flex-1 pt-1.5 flex justify-between space-x-4">
                                                    <div>
                                                        <p class="text-sm text-gray-500 dark:text-gray-400">No assignments yet</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                @endforelse
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Task Actions & Info -->
            <div class="space-y-6">
                <!-- Task Actions -->
                @if($task->status !== 'completed')
                <div class="bg-white dark:bg-gray-800 shadow rounded-lg border border-gray-200 dark:border-gray-700">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-4">Quick Actions</h3>
                        
                        <div class="space-y-3">
                            @can('complete', $task)
                                @if($task->status !== 'completed')
                                    <form action="{{ route('tasks.complete', $task) }}" method="POST">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="w-full inline-flex justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                            <i class="fas fa-check mr-2"></i>
                                            Mark as Completed
                                        </button>
                                    </form>
                                @endif
                            @endcan

                            @can('reassign', $task)
                                <a href="{{ route('tasks.reassign', $task) }}" class="w-full inline-flex justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                                    <i class="fas fa-exchange-alt mr-2"></i>
                                    Reassign Task
                                </a>
                            @endcan
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
