@extends('layouts.app')

@section('title', 'Reassign Task')

@section('content')
<div class="max-w-4xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md overflow-hidden shadow-xl sm:rounded-lg border border-gray-200 dark:border-gray-700">
        <div class="p-6 bg-white dark:bg-transparent border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Reassign Task</h2>
                <a href="{{ route('tasks.show', $task) }}" class="text-gray-400 hover:text-gray-500 dark:hover:text-white transition-colors">
                    <i class="fas fa-times text-xl"></i>
                </a>
            </div>
        </div>

        <div class="p-6">
            <!-- Task Details -->
            <div class="mb-6 p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-2">{{ $task->title }}</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-2">{{ $task->description }}</p>
                <div class="flex items-center space-x-4 text-sm text-gray-500 dark:text-gray-400">
                    <span><i class="fas fa-calendar mr-1"></i> Due: {{ $task->due_date ? $task->due_date->format('M d, Y') : 'No due date' }}</span>
                    <span><i class="fas fa-flag mr-1"></i> Priority: {{ ucfirst($task->priority) }}</span>
                    <span><i class="fas fa-user mr-1"></i> Currently assigned to: {{ $task->assignedTo->name ?? 'Unassigned' }}</span>
                </div>
            </div>

            <!-- Reassignment Form -->
            <form action="{{ route('tasks.reassign', $task) }}" method="POST" class="space-y-6">
                @csrf
                
                <div>
                    <label for="assigned_to" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Assign To <span class="text-red-500 dark:text-red-400">*</span>
                    </label>
                    <select name="assigned_to" id="assigned_to" 
                        class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent" 
                        required>
                        <option value="">Select User</option>
                        @foreach(\App\Models\User::where('id', '!=', $task->current_assigned_to)->get() as $user)
                            <option value="{{ $user->id }}" {{ old('assigned_to') == $user->id ? 'selected' : '' }}>
                                {{ $user->name }} ({{ $user->roles->first()->name ?? 'No Role' }})
                            </option>
                        @endforeach
                    </select>
                    @error('assigned_to')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Notes (Optional)
                    </label>
                    <textarea name="notes" id="notes" rows="4" 
                              class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent" 
                              placeholder="Add any notes about this reassignment...">{{ old('notes') }}</textarea>
                    @error('notes')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex items-center justify-end space-x-4 pt-4 border-t border-gray-200 dark:border-gray-700">
                    <a href="{{ route('tasks.show', $task) }}" 
                       class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        Cancel
                    </a>
                    <button type="submit" 
                            class="px-4 py-2 bg-red-600 border border-transparent rounded-md font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        <i class="fas fa-user-edit mr-2"></i>
                        Reassign Task
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection