@extends('layouts.app')

@section('page-title', 'Tasks')

@section('content')
<div class="bg-white dark:bg-gray-800/50 backdrop-blur-md rounded-lg shadow-xl border border-gray-200 dark:border-gray-700">
    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-4 sm:mb-0">
                <i class="fas fa-tasks mr-3 text-red-500 dark:text-red-400"></i>
                Tasks
            </h1>
            @can('create', App\Models\Task::class)
                <a href="{{ route('tasks.create') }}" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                    <i class="fas fa-plus mr-2"></i>Create Task
                </a>
            @endcan
        </div>
    </div>

    <div class="p-6">
        @if (session('success'))
            <div class="mb-4 bg-green-50 dark:bg-green-900 border border-green-200 dark:border-green-700 text-green-800 dark:text-green-300 px-4 py-3 rounded-md">
                <div class="flex items-center">
                    <i class="fas fa-check-circle mr-2"></i>
                    <div>{{ session('success') }}</div>
                </div>
            </div>
        @endif

        <!-- Enhanced Filters -->
        <div class="mb-6 bg-gray-50 dark:bg-gray-700/50 backdrop-blur-md rounded-lg border border-gray-200 dark:border-gray-600 p-4">
            <form method="GET" action="{{ route('tasks.index') }}" class="space-y-4">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white">
                        <i class="fas fa-filter mr-2 text-red-500 dark:text-red-400"></i>
                        Filters
                    </h3>
                    <button type="button" id="toggleFilters" class="text-gray-500 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white transition-colors duration-200">
                        <i class="fas fa-chevron-down" id="filterIcon"></i>
                    </button>
                </div>
                
                <div id="filterContent" class="space-y-4">
                    <!-- Search and Quick Filters Row -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <!-- Employee Name Search -->
                        <div>
                            <label for="employee_search" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-user mr-1"></i>
                                Employee Name
                            </label>
                            <input type="text" name="employee_search" id="employee_search" value="{{ request('employee_search') }}" placeholder="Search by employee name..."
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <!-- Department Filter -->
                        <div>
                            <label for="department" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-building mr-1"></i>
                                Department
                            </label>
                            <select id="department" name="department" 
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Departments</option>
                                @foreach(\App\Models\Department::all() as $dept)
                                    <option value="{{ $dept->id }}" {{ request('department') == $dept->id ? 'selected' : '' }}>
                                        {{ $dept->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <!-- Status Filter -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-tasks mr-1"></i>
                                Status
                            </label>
                            <select id="status" name="status" 
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                                <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                            </select>
                        </div>
                        
                        <!-- Priority Filter -->
                        <div>
                            <label for="priority" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                Priority
                            </label>
                            <select id="priority" name="priority" 
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Priorities</option>
                                <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>Low</option>
                                <option value="medium" {{ request('priority') == 'medium' ? 'selected' : '' }}>Medium</option>
                                <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>High</option>
                                <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>Urgent</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Date Range and Task Type Row -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <!-- Date From -->
                        <div>
                            <label for="date_from" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-calendar mr-1"></i>
                                Date From
                            </label>
                            <input type="date" id="date_from" name="date_from" 
                                   value="{{ request('date_from') }}"
                                   class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <!-- Date To -->
                        <div>
                            <label for="date_to" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-calendar mr-1"></i>
                                Date To
                            </label>
                            <input type="date" id="date_to" name="date_to" 
                                   value="{{ request('date_to') }}"
                                   class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <!-- Task Type -->
                        <div>
                            <label for="task_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-sitemap mr-1"></i>
                                Task Type
                            </label>
                            <select id="task_type" name="task_type" 
                                    class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Tasks</option>
                                <option value="parent" {{ request('task_type') == 'parent' ? 'selected' : '' }}>Parent Tasks Only</option>
                                <option value="subtask" {{ request('task_type') == 'subtask' ? 'selected' : '' }}>Subtasks Only</option>
                                <option value="main" {{ request('task_type') == 'main' ? 'selected' : '' }}>Main Tasks Only</option>
                            </select>
                        </div>
                        
                        <!-- Overdue Filter -->
                        <div>
                            <label for="overdue" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-clock mr-1"></i>
                                Deadline Status
                            </label>
                            <select id="overdue" name="overdue" 
                                    class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">All Tasks</option>
                                <option value="overdue" {{ request('overdue') == 'overdue' ? 'selected' : '' }}>Overdue Only</option>
                                <option value="due_soon" {{ request('overdue') == 'due_soon' ? 'selected' : '' }}>Due Soon (≤2 days)</option>
                                <option value="no_deadline" {{ request('overdue') == 'no_deadline' ? 'selected' : '' }}>No Deadline</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="flex flex-wrap gap-3 pt-2">
                        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                             <i class="fas fa-search mr-2"></i>
                             Apply Filters
                         </button>
                        <a href="{{ route('tasks.index') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors duration-200">
                            <i class="fas fa-times mr-2"></i>
                            Clear Filters
                        </a>
                        <div class="text-sm text-gray-500 dark:text-gray-400 flex items-center ml-auto">
                            <i class="fas fa-info-circle mr-1"></i>
                            Showing {{ $tasks->count() }} of {{ $tasks->total() }} tasks
                        </div>
                    </div>
                </div>
            </form>
        </div>

        @if($tasks->count() > 0)
            <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md rounded-lg border border-gray-200 dark:border-gray-600 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 dark:bg-gray-700/50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Title</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Priority</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Deadline</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Department</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Assigned To</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-600">
                            @foreach($tasks as $task)
                                <tr class="hover:bg-gray-50 dark:hover:bg-gray-600 transition-colors duration-200 {{ $task->is_overdue ? 'bg-red-50 dark:bg-red-900/20' : '' }}">
                                     <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                         <div class="flex items-center">
                                             @if($task->parent_id)
                                                 <span class="text-gray-400 dark:text-gray-500 mr-2">└─</span>
                                                 <i class="fas fa-tasks text-red-500 dark:text-red-400 mr-2" title="Subtask"></i>
                                             @else
                                                 @if($task->subtasks->count() > 0)
                                                     <i class="fas fa-sitemap text-green-500 dark:text-green-400 mr-2" title="Parent Task ({{ $task->subtasks->count() }} subtasks)"></i>
                                                 @else
                                                     <i class="fas fa-task text-gray-400 mr-2" title="Main Task"></i>
                                                 @endif
                                             @endif
                                             <a href="{{ route('tasks.show', $task) }}" class="text-red-600 dark:text-red-400 hover:text-red-500 dark:hover:text-red-300 transition-colors duration-200 font-medium">
                                                 {{ $task->title }}
                                                 @if($task->is_overdue)
                                                     <i class="fas fa-exclamation-triangle text-red-500 dark:text-red-400 ml-2" title="Overdue"></i>
                                                 @endif
                                             </a>
                                             @if($task->subtasks->count() > 0)
                                                 <span class="ml-2 text-xs text-gray-500 dark:text-gray-400">({{ $task->subtasks->count() }} subtasks)</span>
                                             @endif
                                         </div>
                                     </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            {{ $task->priority === 'urgent' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300' :
                                            ($task->priority === 'high' ? 'bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300' :
                                            ($task->priority === 'medium' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300' : 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300')) }}">
                                            {{ ucfirst($task->priority) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 dark:text-gray-300">
                                        @if($task->deadline)
                                            <div class="{{ $task->is_overdue ? 'text-red-600 dark:text-red-400' : ($task->daysUntilDeadline() <= 1 ? 'text-yellow-600 dark:text-yellow-400' : 'text-gray-600 dark:text-gray-300') }}">
                                                {{ $task->deadline->format('M d, Y H:i') }}
                                                @if($task->daysUntilDeadline() !== null)
                                                    <br><small class="text-xs">
                                                        @if($task->is_overdue)
                                                            {{ abs($task->daysUntilDeadline()) }} days overdue
                                                        @else
                                                            {{ $task->daysUntilDeadline() }} days left
                                                        @endif
                                                    </small>
                                                @endif
                                            </div>
                                        @else
                                            <span class="text-gray-500">No deadline</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 dark:text-gray-300">{{ $task->currentDepartment->name ?? 'N/A' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                        @if($task->assignedTo)
                                            <a href="{{ route('staff.show', $task->assignedTo) }}" class="text-red-600 dark:text-red-400 hover:text-red-500 dark:hover:text-red-300 transition-colors duration-200">
                                                {{ $task->assignedTo->name }}
                                            </a>
                                        @else
                                            <span class="text-gray-400">Unassigned</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                            {{ $task->status === 'completed' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300' : 
                                            ($task->status === 'in_progress' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300' : 
                                            ($task->status === 'cancelled' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300' : 
                                            ($task->status === 'pending' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300'))) }}">
                                            {{ ucfirst(str_replace('_', ' ', $task->status)) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex space-x-2">
                                            <a href="{{ route('tasks.show', $task) }}" class="bg-red-600 hover:bg-red-700 text-white px-3 py-1 rounded text-xs transition-colors duration-200">
                                                <i class="fas fa-eye mr-1"></i>
                                                View
                                            </a>
                                            @if(auth()->user()->role === 'admin' || auth()->user()->id === $task->assigned_to)
                                                <a href="{{ route('tasks.edit', $task) }}" class="bg-yellow-500 hover:bg-yellow-600 text-white px-3 py-1 rounded text-xs transition-colors duration-200">
                                                    <i class="fas fa-edit mr-1"></i>
                                                    Edit
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        </table>
                </div>
            </div>

            <div class="mt-6 flex justify-center">
                {{ $tasks->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <i class="fas fa-tasks text-6xl text-gray-300 dark:text-gray-600 mb-4"></i>
                <h3 class="text-xl font-medium text-gray-900 dark:text-gray-300 mb-2">No tasks found</h3>
                <p class="text-gray-500 dark:text-gray-400 mb-6">Get started by creating your first task.</p>
                @can('create', App\Models\Task::class)
                    <a href="{{ route('tasks.create') }}" class="bg-red-600 hover:bg-red-700 text-white px-6 py-3 rounded-md font-medium transition-colors duration-200">
                        <i class="fas fa-plus mr-2"></i>Create First Task
                    </a>
                @endcan
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
// Toggle filter visibility
document.getElementById('toggleFilters').addEventListener('click', function() {
    const content = document.getElementById('filterContent');
    const icon = document.getElementById('filterIcon');
    
    if (content.style.display === 'none') {
        content.style.display = 'block';
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-up');
        localStorage.setItem('filtersExpanded', 'true');
    } else {
        content.style.display = 'none';
        icon.classList.remove('fa-chevron-up');
        icon.classList.add('fa-chevron-down');
        localStorage.setItem('filtersExpanded', 'false');
    }
});

// Restore filter state from localStorage
document.addEventListener('DOMContentLoaded', function() {
    const filtersExpanded = localStorage.getItem('filtersExpanded');
    const content = document.getElementById('filterContent');
    const icon = document.getElementById('filterIcon');
    
    if (filtersExpanded === 'false') {
        content.style.display = 'none';
        icon.classList.remove('fa-chevron-up');
        icon.classList.add('fa-chevron-down');
    } else {
        content.style.display = 'block';
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-up');
    }
    
    // Auto-submit form on filter change for better UX
    const filterInputs = document.querySelectorAll('#filterContent select, #filterContent input[type="date"]');
    filterInputs.forEach(input => {
        input.addEventListener('change', function() {
            // Small delay to allow user to make multiple selections
            setTimeout(() => {
                this.closest('form').submit();
            }, 300);
        });
    });
    
    // Real-time search for employee name
    const employeeSearch = document.getElementById('employee_search');
    let searchTimeout;
    employeeSearch.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            this.closest('form').submit();
        }, 500); // Wait 500ms after user stops typing
    });
});
</script>
@endpush
