@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-transparent py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Edit Task</h1>
                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-300">Update task information and settings</p>
                    </div>
                    <a href="{{ route('tasks.show', $task) }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to Task
                    </a>
                </div>
            </div>
        </div>

        <!-- Error Messages -->
        @if ($errors->any())
            <div class="bg-red-50 dark:bg-red-900/50 border border-red-200 dark:border-red-700 text-red-700 dark:text-red-200 px-4 py-3 rounded mb-6">
                <div class="flex">
                    <div class="py-1">
                        <i class="fas fa-exclamation-triangle text-red-500 dark:text-red-400"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium">Please correct the following errors:</p>
                        <ul class="mt-2 text-sm list-disc list-inside">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        @endif

        <!-- Edit Form -->
        <form action="{{ route('tasks.update', $task) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Task Information</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Title -->
                        <div class="md:col-span-2">
                            <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Task Title *</label>
                            <input type="text" name="title" id="title" value="{{ old('title', $task->title) }}" required
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>

                        <!-- Assigned To -->
                        <div>
                            <label for="current_assigned_to" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Assign To</label>
                            <select name="current_assigned_to" id="current_assigned_to"
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">Select Staff Member</option>
                                @foreach($users as $member)
                                    <option value="{{ $member->id }}" {{ old('current_assigned_to', $task->current_assigned_to) == $member->id ? 'selected' : '' }}>
                                        {{ $member->name }} @if($member->staffProfile && $member->staffProfile->department)({{ $member->staffProfile->department->name }})@endif
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Department -->
                        <div>
                            <label for="current_department_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Department</label>
                            <select name="current_department_id" id="current_department_id"
                                class="w-full px-3 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="">Select Department</option>
                                @foreach($departments as $department)
                                    <option value="{{ $department->id }}" {{ old('current_department_id', $task->current_department_id) == $department->id ? 'selected' : '' }}>
                                        {{ $department->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>



                        <!-- Status -->
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Status *</label>
                            <select name="status" id="status" required
                                class="w-full px-3 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                                <option value="pending" {{ old('status', $task->status) === 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="in_progress" {{ old('status', $task->status) === 'in_progress' ? 'selected' : '' }}>In Progress</option>
                                <option value="completed" {{ old('status', $task->status) === 'completed' ? 'selected' : '' }}>Completed</option>
                                <option value="cancelled" {{ old('status', $task->status) === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                        </div>



                        <!-- Description -->
                        <div class="md:col-span-2">
                            <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Description</label>
                            <textarea name="description" id="description" rows="4"
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent"
                                placeholder="Provide detailed task description...">{{ old('description', $task->description) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Completion Details (if completed) -->
            @if($task->status === 'completed')
            <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mt-6">
                <div class="px-4 py-5 sm:p-6">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-4 mb-6">Completion Details</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Actual Hours -->
                        <div>
                            <label for="actual_hours" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Actual Hours Spent</label>
                            <input type="number" name="actual_hours" id="actual_hours" min="0" step="0.5"
                                value="{{ old('actual_hours', $task->actual_hours) }}"
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent"
                                placeholder="e.g., 7.5">
                        </div>

                        <!-- Completion Notes -->
                        <div class="md:col-span-2">
                            <label for="completion_notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Completion Notes</label>
                            <textarea name="completion_notes" id="completion_notes" rows="3"
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent"
                                placeholder="Add any notes about task completion...">{{ old('completion_notes', $task->completion_notes) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Form Actions -->
            <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mt-6">
                <div class="px-4 py-5 sm:p-6">
                    <div class="flex items-center justify-end space-x-3">
                        <a href="{{ route('tasks.show', $task) }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            Cancel
                        </a>
                        <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            <i class="fas fa-save mr-2"></i>
                            Update Task
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
// Auto-update status when task is marked as completed
document.getElementById('status').addEventListener('change', function() {
    const completionSection = document.querySelector('.completion-details');
    if (this.value === 'completed') {
        // Show completion fields if they exist
        const actualHours = document.getElementById('actual_hours');
        const completionNotes = document.getElementById('completion_notes');
        if (actualHours) actualHours.closest('.grid').style.display = 'grid';
    }
});
</script>
@endsection