@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-transparent py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700 mb-6">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">{{ __('Create Subtask') }}</h1>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300">Create a subtask for: <span class="text-red-600 dark:text-red-400 font-medium">{{ $task->title }}</span></p>
                    </div>
                    <a href="{{ route('tasks.index') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>

        <!-- Parent Task Info -->
        <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-700 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-sitemap text-red-500 dark:text-red-400 mr-3"></i>
                <div>
                    <h3 class="text-lg font-medium text-red-800 dark:text-red-300">Parent Task</h3>
                    <p class="text-red-700 dark:text-red-200">{{ $task->title }}</p>
                    <p class="text-sm text-red-600 dark:text-red-400 mt-1">{{ Str::limit($task->description, 100) }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow rounded-lg border border-gray-200 dark:border-gray-700">
            <div class="px-4 py-5 sm:p-6">
                <form method="POST" action="{{ route('tasks.store') }}">
                    @csrf
                    <input type="hidden" name="parent_id" value="{{ $task->id }}">

                    <div class="grid grid-cols-1 gap-6">
                        <div>
                            <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Subtask Title') }} *</label>
                            <input id="title" type="text" name="title" value="{{ old('title') }}" required autofocus
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent @error('title') border-red-500 @enderror"
                                placeholder="Enter subtask title...">
                            @error('title')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Description') }} *</label>
                            <textarea id="description" name="description" rows="4" required
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent @error('description') border-red-500 @enderror"
                                placeholder="Provide detailed subtask description...">{{ old('description') }}</textarea>
                            @error('description')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="current_department_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Department') }} *</label>
                            <select id="current_department_id" name="current_department_id" required
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent @error('current_department_id') border-red-500 @enderror">
                                <option value="">Select Department</option>
                                @foreach($departments as $department)
                                    <option value="{{ $department->id }}" {{ old('current_department_id', $task->current_department_id) == $department->id ? 'selected' : '' }}>
                                        {{ $department->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('current_department_id')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="current_assigned_to" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Assign To (Optional)') }}</label>
                            <select id="current_assigned_to" name="current_assigned_to"
                                class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent @error('current_assigned_to') border-red-500 @enderror">
                                <option value="">Select Staff Member</option>
                            </select>
                            @error('current_assigned_to')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="deadline" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Deadline (Optional)') }}</label>
                                <input id="deadline" type="date" name="deadline" value="{{ old('deadline') }}"
                                    class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent @error('deadline') border-red-500 @enderror">
                                @error('deadline')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="priority" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">{{ __('Priority') }}</label>
                                <select id="priority" name="priority"
                            class="w-full px-3 py-2 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent @error('priority') border-red-500 @enderror">
                            <option value="low" {{ old('priority', $task->priority) == 'low' ? 'selected' : '' }}>Low</option>
                                    <option value="medium" {{ old('priority', $task->priority) == 'medium' ? 'selected' : '' }}>Medium</option>
                                    <option value="high" {{ old('priority', $task->priority) == 'high' ? 'selected' : '' }}>High</option>
                                    <option value="urgent" {{ old('priority', $task->priority) == 'urgent' ? 'selected' : '' }}>Urgent</option>
                                </select>
                                @error('priority')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mt-6 flex items-center justify-end space-x-3">
                        <a href="{{ route('tasks.show', $task) }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            <i class="fas fa-times mr-2"></i>
                            Cancel
                        </a>
                        <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            <i class="fas fa-save mr-2"></i>
                            Create Subtask
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const departmentSelect = document.getElementById('current_department_id');
    const userSelect = document.getElementById('current_assigned_to');
    const oldAssignedTo = '{{ old("current_assigned_to") }}';
    
    // Function to load users by department
    function loadUsersByDepartment(departmentId) {
        if (!departmentId) {
            userSelect.innerHTML = '<option value="">Select Staff Member</option>';
            return;
        }
        
        // Show loading state
        userSelect.innerHTML = '<option value="">Loading...</option>';
        
        fetch(`/api/departments/${departmentId}/users`)
            .then(response => response.json())
            .then(users => {
                userSelect.innerHTML = '<option value="">Select Staff Member</option>';
                
                users.forEach(user => {
                    const option = document.createElement('option');
                    option.value = user.id;
                    option.textContent = user.name;
                    
                    // Restore old selection if it matches
                    if (oldAssignedTo && oldAssignedTo == user.id) {
                        option.selected = true;
                    }
                    
                    userSelect.appendChild(option);
                });
                
                if (users.length === 0) {
                    userSelect.innerHTML = '<option value="">No staff members in this department</option>';
                }
            })
            .catch(error => {
                console.error('Error loading users:', error);
                userSelect.innerHTML = '<option value="">Error loading staff members</option>';
            });
    }
    
    // Handle department change
    departmentSelect.addEventListener('change', function() {
        loadUsersByDepartment(this.value);
    });
    
    // Load users for initially selected department (if any)
    const initialDepartment = departmentSelect.value || '{{ old("current_department_id", $task->current_department_id) }}';
    if (initialDepartment) {
        departmentSelect.value = initialDepartment;
        loadUsersByDepartment(initialDepartment);
    }
});
</script>
@endsection