@extends('layouts.app')

@section('title', 'Stock Management')

@section('content')
<div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl border border-gray-200 dark:border-gray-700">
    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-4 sm:mb-0">
                <i class="fas fa-boxes mr-3 text-red-600 dark:text-red-400"></i>
                Stock Management
            </h1>
            <div class="flex items-center space-x-4">
                @role('Admin')
                <a href="{{ route('stock.upload.form') }}" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                    <i class="fas fa-upload mr-2"></i>Upload Stock Data
                </a>
                @endrole
            </div>
        </div>
    </div>

    <div class="p-6">
        @if(session('success'))
            <div class="mb-6 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-700 text-green-700 dark:text-green-300 px-4 py-3 rounded-md">
                <div class="flex items-center">
                    <i class="fas fa-check-circle mr-2"></i>
                    <div>
                        <strong class="font-bold">Success!</strong>
                        <span class="block sm:inline">{{ session('success') }}</span>
                    </div>
                </div>
            </div>
        @endif

        <!-- Filters -->
        <div class="mb-6 bg-gray-50 dark:bg-gray-700 rounded-lg p-4 border border-gray-200 dark:border-gray-600">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900 dark:text-white">
                    <i class="fas fa-filter mr-2 text-red-600 dark:text-red-400"></i>
                    Filters
                </h3>
                <button type="button" id="toggleFilters" class="text-gray-500 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white transition-colors duration-200">
                    <i class="fas fa-chevron-down" id="filterIcon"></i>
                </button>
            </div>
            
            <div id="filterContent" class="space-y-4" style="display: block;">
                <form method="POST" action="{{ route('stock.index') }}" id="stockFilterForm">
                    @csrf
                    <!-- Search Row -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                        <div>
                            <label for="search_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-search mr-1"></i>
                                Search Name
                            </label>
                            <input type="text" name="search_name" id="search_name" value="{{ request('search_name') }}" placeholder="Type to search names..."
                                class="w-full px-3 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="search_product" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-search mr-1"></i>
                                Search Product
                            </label>
                            <input type="text" name="search_product" id="search_product" value="{{ request('search_product') }}" placeholder="Type to search products..."
                                class="w-full px-3 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                        
                        <div>
                            <label for="search_style" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                <i class="fas fa-search mr-1"></i>
                                Search Style
                            </label>
                            <input type="text" name="search_style" id="search_style" value="{{ request('search_style') }}" placeholder="Type to search styles..."
                                class="w-full px-3 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-md text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent">
                        </div>
                    </div>
                    
                    <!-- Filter Dropdowns Row -->
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Name</label>
                            <select name="name" id="name" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Names</option>
                                @foreach($filterData['names'] as $name)
                                    <option value="{{ $name }}" {{ request('name') == $name ? 'selected' : '' }}>{{ $name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="product" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Product</label>
                            <select name="product" id="product" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Products</option>
                                @foreach($filterData['products'] as $product)
                                    <option value="{{ $product }}" {{ request('product') == $product ? 'selected' : '' }}>{{ $product }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="style" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Style</label>
                            <select name="style" id="style" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Styles</option>
                                @foreach($filterData['styles'] as $style)
                                    <option value="{{ $style }}" {{ request('style') == $style ? 'selected' : '' }}>{{ $style }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="color" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Color</label>
                            <select name="color" id="color" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Colors</option>
                                @foreach($filterData['colors'] as $color)
                                    <option value="{{ $color }}" {{ request('color') == $color ? 'selected' : '' }}>{{ $color }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="size" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Size</label>
                            <select name="size" id="size" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Sizes</option>
                                @foreach($filterData['sizes'] as $size)
                                    <option value="{{ $size }}" {{ request('size') == $size ? 'selected' : '' }}>{{ $size }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="batch_no" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Batch No</label>
                            <select name="batch_no" id="batch_no" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-900 dark:text-white rounded-md focus:ring-2 focus:ring-red-500 focus:border-red-500">
                                <option value="">All Batches</option>
                                @foreach($filterData['batchNos'] as $batchNo)
                                    <option value="{{ $batchNo }}" {{ request('batch_no') == $batchNo ? 'selected' : '' }}>{{ $batchNo }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <!-- Action Buttons Row -->
                    <div class="mt-6 flex items-center justify-between">
                        <div class="flex space-x-3">
                            <button type="submit" id="searchButton" class="bg-red-600 hover:bg-red-700 text-white px-6 py-2 rounded-lg text-sm font-medium transition-colors duration-200 flex items-center">
                                <i class="fas fa-search mr-2"></i>Search
                            </button>
                            <button type="button" id="clearFiltersButton" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200 flex items-center">
                                <i class="fas fa-times mr-2"></i>Clear Filters
                            </button>
                        </div>
                        <div class="text-sm text-gray-500 dark:text-gray-400">
                            <i class="fas fa-info-circle mr-1"></i>
                            <span id="resultsCount">Showing {{ $stocks->firstItem() ?? 0 }} to {{ $stocks->lastItem() ?? 0 }} of {{ $stocks->total() }} results</span>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Stock Table -->
        <div class="bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-600 overflow-hidden">
            @include('stock.partials.table', ['stocks' => $stocks])
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('Stock page JavaScript loaded - Traditional form submission enabled');
    
    // Toggle filter visibility
    const toggleButton = document.getElementById('toggleFilters');
    const filterContent = document.getElementById('filterContent');
    const filterIcon = document.getElementById('filterIcon');
    
    if (toggleButton && filterContent && filterIcon) {
        // Ensure filters are visible by default
        filterContent.style.display = 'block';
        filterIcon.classList.remove('fa-chevron-down');
        filterIcon.classList.add('fa-chevron-up');
        
        toggleButton.addEventListener('click', function() {
            if (filterContent.style.display === 'none') {
                filterContent.style.display = 'block';
                filterIcon.classList.remove('fa-chevron-down');
                filterIcon.classList.add('fa-chevron-up');
            } else {
                filterContent.style.display = 'none';
                filterIcon.classList.remove('fa-chevron-up');
                filterIcon.classList.add('fa-chevron-down');
            }
        });
    }
    
    // Handle clear filters button
    const clearFiltersBtn = document.getElementById('clearFiltersButton');
    if (clearFiltersBtn) {
        clearFiltersBtn.addEventListener('click', function(e) {
            e.preventDefault();
            console.log('Clear filters button clicked');
            
            // Clear all inputs and selects
            const form = document.getElementById('stockFilterForm');
            if (form) {
                form.reset();
                // Submit the form to show all results
                form.submit();
            }
        });
    }
    
    console.log('Traditional form submission mode - Search button will submit form to backend');
});
</script>
@endpush
@endsection