<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Payslip</title>
    <style>
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            font-size: 12px;
            color: #333;
        }
        .container {
            width: 100%;
            margin: 0 auto;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 10px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #2c3e50;
            margin: 0;
        }
        .company-address {
            font-size: 12px;
            color: #7f8c8d;
            margin-top: 5px;
        }
        .payslip-title {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 20px;
            text-transform: uppercase;
            color: #2c3e50;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            background-color: #f2f2f2;
            padding: 5px 10px;
            margin-bottom: 10px;
            border-left: 4px solid #3498db;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .info-table td {
            padding: 5px;
            vertical-align: top;
        }
        .info-label {
            font-weight: bold;
            color: #555;
            width: 120px;
        }
        .salary-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .salary-table th, .salary-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .salary-table th {
            background-color: #f9f9f9;
            font-weight: bold;
            text-align: center;
        }
        .amount-col {
            text-align: right;
        }
        .total-row td {
            font-weight: bold;
            background-color: #f2f2f2;
        }
        .net-pay-section {
            background-color: #e8f6f3;
            border: 1px solid #d1f2eb;
            padding: 15px;
            margin-top: 20px;
            text-align: right;
        }
        .net-pay-label {
            font-size: 14px;
            font-weight: bold;
            color: #16a085;
        }
        .net-pay-amount {
            font-size: 20px;
            font-weight: bold;
            color: #16a085;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 10px;
            color: #999;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .signature-section {
            margin-top: 50px;
            width: 100%;
        }
        .signature-box {
            width: 40%;
            float: right;
            border-top: 1px solid #333;
            text-align: center;
            padding-top: 5px;
        }
        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1 class="company-name">Staff Management System</h1>
            <p class="company-address">123 Corporate Park, Business District, City, Country - 123456</p>
        </div>

        <div class="payslip-title">
            Payslip for {{ \Carbon\Carbon::createFromDate($payroll->year, $payroll->month, 1)->format('F Y') }}
        </div>

        <div class="section-title">Employee Details</div>
        <table class="info-table">
            <tr>
                <td width="50%">
                    <table width="100%">
                        <tr>
                            <td class="info-label">Name:</td>
                            <td>{{ $payroll->user->name }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">Employee ID:</td>
                            <td>{{ $payroll->user->staffProfile->employee_id ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">Department:</td>
                            <td>{{ $payroll->user->staffProfile->department->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">Designation:</td>
                            <td>{{ $payroll->user->staffProfile->position ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </td>
                <td width="50%">
                    <table width="100%">
                        <tr>
                            <td class="info-label">Bank Name:</td>
                            <td>{{ $payroll->user->staffProfile->bank_name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">Account No:</td>
                            <td>{{ $payroll->user->staffProfile->bank_account_no ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">IFSC Code:</td>
                            <td>{{ $payroll->user->staffProfile->ifsc_code ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="info-label">Payslip No:</td>
                            <td>#{{ str_pad($payroll->id, 6, '0', STR_PAD_LEFT) }}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>

        <div class="section-title">Attendance Details</div>
        <table class="info-table">
            <tr>
                <td width="25%" class="info-label">Total Days:</td>
                <td width="25%">{{ \Carbon\Carbon::createFromDate($payroll->year, $payroll->month, 1)->daysInMonth }}</td>
                <td width="25%" class="info-label">Days Worked:</td>
                <td width="25%">{{ $payroll->days_present }}</td>
            </tr>
            <tr>
                <td class="info-label">Paid Leaves:</td>
                <td>{{ $payroll->paid_leave_days ?? 0 }}</td>
                <td class="info-label">LWP (Unpaid):</td>
                <td>{{ (\Carbon\Carbon::createFromDate($payroll->year, $payroll->month, 1)->daysInMonth) - ($payroll->days_present + ($payroll->paid_leave_days ?? 0)) }}</td>
            </tr>
        </table>

        <div class="section-title">Salary Details</div>
        <table class="salary-table">
            <thead>
                <tr>
                    <th>Earnings</th>
                    <th>Amount (₹)</th>
                    <th>Deductions</th>
                    <th>Amount (₹)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Basic Salary</td>
                    <td class="amount-col">{{ number_format($payroll->basic_salary, 2) }}</td>
                    <td>PF</td>
                    <td class="amount-col">{{ number_format($payroll->employee_pf ?? 0, 2) }}</td>
                </tr>
                <tr>
                    <td>HRA</td>
                    <td class="amount-col">{{ number_format($payroll->hra, 2) }}</td>
                    <td>ESI</td>
                    <td class="amount-col">{{ number_format($payroll->employee_esi ?? 0, 2) }}</td>
                </tr>
                <tr>
                    <td>Conveyance</td>
                    <td class="amount-col">{{ number_format($payroll->conveyance, 2) }}</td>
                    <td>Professional Tax</td>
                    <td class="amount-col">{{ number_format($payroll->professional_tax ?? 0, 2) }}</td>
                </tr>
                <tr>
                    <td>Special Allowance</td>
                    <td class="amount-col">{{ number_format($payroll->special_allowance, 2) }}</td>
                    <td>Other Deductions</td>
                    <td class="amount-col">0.00</td>
                </tr>
                <tr>
                    <td>Bonus</td>
                    <td class="amount-col">0.00</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td>Overtime</td>
                    <td class="amount-col">0.00</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr class="total-row">
                    <td>Total Earnings</td>
                    <td class="amount-col">{{ number_format($payroll->gross_salary, 2) }}</td>
                    <td>Total Deductions</td>
                    <td class="amount-col">{{ number_format(($payroll->employee_pf ?? 0) + ($payroll->employee_esi ?? 0) + ($payroll->professional_tax ?? 0), 2) }}</td>
                </tr>
            </tbody>
        </table>

        <div class="net-pay-section">
            <div class="net-pay-label">Net Payable Amount</div>
            <div class="net-pay-amount">₹ {{ number_format($payroll->net_salary, 2) }}</div>
            <div style="font-size: 12px; color: #7f8c8d; margin-top: 5px;">
                (Rupees {{ ucfirst((new NumberFormatter("en", NumberFormatter::SPELLOUT))->format($payroll->net_salary)) }} Only)
            </div>
        </div>

        <div class="clearfix"></div>

        <div class="signature-section">
            <div class="signature-box">
                Authorized Signatory
            </div>
        </div>

        <div class="footer">
            <p>This is a computer-generated document and does not require a physical signature.</p>
        </div>
    </div>
</body>
</html>
