<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Staff Management System')</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script>
        // On page load or when changing themes, best to add inline in `head` to avoid FOUC
        // Default to dark mode if no preference is saved or if preference is 'dark'
        if (localStorage.getItem('color-theme') === 'dark' || (!('color-theme' in localStorage))) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }

        // Define global toggle function
        window.toggleTheme = function() {
            try {
                if (document.documentElement.classList.contains('dark')) {
                    document.documentElement.classList.remove('dark');
                    localStorage.setItem('color-theme', 'light');
                    console.log('Theme switched to light');
                } else {
                    document.documentElement.classList.add('dark');
                    localStorage.setItem('color-theme', 'dark');
                    console.log('Theme switched to dark');
                }
            } catch (e) {
                console.error('Theme toggle failed:', e);
            }
        };
    </script>
</head>
<body class="bg-gray-100 dark:bg-gray-900 min-h-screen font-inter text-gray-900 dark:text-gray-100 antialiased transition-colors duration-300">
    <div id="app" class="min-h-screen">
        @auth
            <div class="flex h-screen bg-transparent">
                <!-- Mobile sidebar overlay -->
                <div class="fixed inset-0 z-40 md:hidden" id="mobile-sidebar-overlay" style="display: none;">
                    <div class="fixed inset-0 bg-gray-600 bg-opacity-75" onclick="toggleMobileSidebar()"></div>
                </div>

                <!-- Sidebar -->
                <div class="hidden md:flex md:w-64 md:flex-col" id="desktop-sidebar">
                    <div class="flex flex-col flex-grow pt-5 overflow-y-auto bg-white dark:bg-gray-800 border-r border-gray-200 dark:border-gray-700">
                        <div class="flex items-center flex-shrink-0 px-4">
                            <h1 class="text-xl font-bold text-gray-800 dark:text-white">Staff Manager</h1>
                        </div>
                        <div class="mt-8 flex-grow flex flex-col">
                            <nav class="flex-1 px-2 pb-4 space-y-1">
                                <a href="{{ route('dashboard') }}" class="{{ request()->routeIs('dashboard') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-tachometer-alt mr-3 text-lg {{ request()->routeIs('dashboard') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Dashboard
                                </a>
                                
                                @role('Admin')
                                <a href="{{ route('staff.index') }}" class="{{ request()->routeIs('staff.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-users mr-3 text-lg {{ request()->routeIs('staff.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Staff Management
                                </a>
                                @endrole
                                
                                <a href="{{ route('tasks.index') }}" class="{{ request()->routeIs('tasks.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-tasks mr-3 text-lg {{ request()->routeIs('tasks.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Tasks
                                </a>
                                
                                @role('Admin')
                                <a href="{{ route('attendance.index') }}" class="{{ request()->routeIs('attendance.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-calendar-check mr-3 text-lg {{ request()->routeIs('attendance.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Attendance
                                </a>
                                
                                <a href="{{ route('payrolls.index') }}" class="{{ request()->routeIs('payrolls.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-money-bill-wave mr-3 text-lg {{ request()->routeIs('payrolls.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Payroll
                                </a>

                                <a href="{{ route('reimbursements.index') }}" class="{{ request()->routeIs('reimbursements.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-receipt mr-3 text-lg {{ request()->routeIs('reimbursements.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Reimbursements
                                </a>
                                
                                <a href="{{ route('leaves.requests.index') }}" class="{{ request()->routeIs('leaves.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-plane-departure mr-3 text-lg {{ request()->routeIs('leaves.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Leave Management
                                </a>
                                
                                <a href="{{ route('performance.index') }}" class="{{ request()->routeIs('performance.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-chart-line mr-3 text-lg {{ request()->routeIs('performance.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Performance Analytics
                                </a>
                                
                                <a href="{{ route('stock.index') }}" class="{{ request()->routeIs('stock.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-boxes mr-3 text-lg {{ request()->routeIs('stock.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    Stock Management
                                </a>
                                @else
                                <a href="{{ route('attendance.staff') }}" class="{{ request()->routeIs('attendance.*') ? 'bg-red-100 dark:bg-red-900/50 text-red-700 dark:text-red-300 shadow-md ring-1 ring-red-200 dark:ring-red-800' : 'bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600 hover:text-gray-900 dark:hover:text-white shadow-sm ring-1 ring-gray-200 dark:ring-gray-600' }} group flex items-center px-3 py-2 text-sm font-bold rounded-lg mb-3 transition-all duration-200 ease-in-out transform hover:scale-[1.02]">
                                    <i class="fas fa-calendar-check mr-3 text-lg {{ request()->routeIs('attendance.*') ? 'text-red-500 dark:text-red-400' : 'text-gray-500 dark:text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300' }}"></i>
                                    My Attendance
                                </a>
                                @endrole
                            </nav>
                        </div>
                    </div>
                </div>

                <!-- Mobile sidebar -->
                <div class="fixed inset-y-0 left-0 z-50 w-64 bg-gray-800 transform -translate-x-full transition-transform duration-300 ease-in-out md:hidden" id="mobile-sidebar">
                    <div class="flex flex-col flex-grow pt-5 overflow-y-auto bg-gray-800 border-r border-gray-700">
                        <div class="flex items-center justify-between flex-shrink-0 px-4">
                            <h1 class="text-xl font-bold text-white">Staff Manager</h1>
                            <button type="button" class="md:hidden p-2 rounded-md text-gray-400 hover:text-gray-300 hover:bg-gray-700" onclick="toggleMobileSidebar()">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>

                        <nav class="flex-1 px-2 pb-4 space-y-1 mt-8">
                            <a href="{{ route('dashboard') }}" class="{{ request()->routeIs('dashboard') ? 'bg-red-900/50 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-3 py-2 text-sm font-medium rounded-md mb-1 transition-colors duration-150 ease-in-out" onclick="toggleMobileSidebar()">
                                <i class="fas fa-tachometer-alt mr-3 text-sm {{ request()->routeIs('dashboard') ? 'text-red-400' : 'text-gray-500 group-hover:text-gray-300' }}"></i>
                                Dashboard
                            </a>
                            
                            @role('Admin')
                            <a href="{{ route('staff.index') }}" class="{{ request()->routeIs('staff.*') ? 'bg-red-900/50 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-3 py-2 text-sm font-medium rounded-md mb-1 transition-colors duration-150 ease-in-out" onclick="toggleMobileSidebar()">
                                <i class="fas fa-users mr-3 text-sm {{ request()->routeIs('staff.*') ? 'text-red-400' : 'text-gray-500 group-hover:text-gray-300' }}"></i>
                                Staff Management
                            </a>
                            @endrole
                            
                            <a href="{{ route('tasks.index') }}" class="{{ request()->routeIs('tasks.*') ? 'bg-red-900/50 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-3 py-2 text-sm font-medium rounded-md mb-1 transition-colors duration-150 ease-in-out" onclick="toggleMobileSidebar()">
                                <i class="fas fa-tasks mr-3 text-sm {{ request()->routeIs('tasks.*') ? 'text-red-400' : 'text-gray-500 group-hover:text-gray-300' }}"></i>
                                Tasks
                            </a>
                            
                            @role('Admin')
                            <a href="{{ route('attendance.index') }}" class="{{ request()->routeIs('attendance.*') ? 'bg-red-900/50 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-3 py-2 text-sm font-medium rounded-md mb-1 transition-colors duration-150 ease-in-out" onclick="toggleMobileSidebar()">
                                <i class="fas fa-calendar-check mr-3 text-sm {{ request()->routeIs('attendance.*') ? 'text-red-400' : 'text-gray-500 group-hover:text-gray-300' }}"></i>
                                Attendance
                            </a>
                            
                            <a href="{{ route('payrolls.index') }}" class="{{ request()->routeIs('payrolls.*') ? 'bg-red-900/50 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-3 py-2 text-sm font-medium rounded-md mb-1 transition-colors duration-150 ease-in-out" onclick="toggleMobileSidebar()">
                                <i class="fas fa-money-bill-wave mr-3 text-sm {{ request()->routeIs('payrolls.*') ? 'text-red-400' : 'text-gray-500 group-hover:text-gray-300' }}"></i>
                                Payroll
                            </a>
                            
                            <a href="{{ route('performance.index') }}" class="{{ request()->routeIs('performance.*') ? 'bg-red-900/50 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-3 py-2 text-sm font-medium rounded-md mb-1 transition-colors duration-150 ease-in-out" onclick="toggleMobileSidebar()">
                                <i class="fas fa-chart-line mr-3 text-sm {{ request()->routeIs('performance.*') ? 'text-red-400' : 'text-gray-500 group-hover:text-gray-300' }}"></i>
                                Performance Analytics
                            </a>
                            @endrole
                            
                            @role('Admin')
                            @else
                            <a href="{{ route('attendance.staff') }}" class="{{ request()->routeIs('attendance.*') ? 'bg-red-900/50 text-red-300' : 'text-gray-300 hover:bg-gray-700 hover:text-white' }} group flex items-center px-3 py-2 text-sm font-medium rounded-md mb-1 transition-colors duration-150 ease-in-out" onclick="toggleMobileSidebar()">
                                <i class="fas fa-calendar-check mr-3 text-sm {{ request()->routeIs('attendance.*') ? 'text-red-400' : 'text-gray-500 group-hover:text-gray-300' }}"></i>
                                My Attendance
                            </a>
                            @endrole
                        </nav>
                    </div>
                </div>

                <!-- Main content -->
                <div class="flex flex-col flex-1 overflow-hidden">
                    <!-- Top navigation -->
                    <header class="bg-white dark:bg-gray-800/50 backdrop-blur-md shadow-sm border-b border-gray-200 dark:border-gray-700 relative z-30">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                            <div class="flex justify-between h-16">
                                <div class="flex items-center">
                                    <button type="button" class="md:hidden p-2 rounded-md text-gray-400 hover:text-gray-300 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-red-500" onclick="toggleMobileSidebar()">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <h2 class="ml-4 text-lg font-semibold text-gray-900 dark:text-white">@yield('page-title', 'Dashboard')</h2>
                                </div>
                                <div class="flex items-center space-x-4">
                                    <!-- Theme Toggle -->
                                    <button id="theme-toggle" type="button" onclick="window.toggleTheme()" class="text-gray-500 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-700 focus:outline-none focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 rounded-lg text-sm p-2.5 transition-colors duration-200 cursor-pointer relative z-50">
                                        <i class="fas fa-sun hidden dark:block text-yellow-400 pointer-events-none"></i>
                                        <i class="fas fa-moon block dark:hidden text-gray-600 pointer-events-none"></i>
                                    </button>

                                    <div class="relative">
                                        <button type="button" class="flex items-center text-sm rounded-full focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500" id="user-menu-button">
                                            <div class="h-8 w-8 rounded-full bg-gradient-to-r from-red-500 to-red-600 flex items-center justify-center">
                                                <span class="text-sm font-medium text-white">{{ substr(Auth::user()->name, 0, 1) }}</span>
                                            </div>
                                            <span class="ml-3 text-gray-900 dark:text-white text-sm font-medium">{{ Auth::user()->name }}</span>
                                            <i class="fas fa-chevron-down ml-2 text-xs text-gray-500 dark:text-gray-400"></i>
                                        </button>
                                        <div class="hidden absolute right-0 z-10 mt-2 w-48 origin-top-right rounded-md bg-white dark:bg-gray-800 py-1 shadow-lg ring-1 ring-black ring-opacity-5 dark:ring-gray-700 focus:outline-none" id="user-menu">
                                            <div class="px-4 py-2 text-xs text-gray-500 dark:text-gray-400 border-b border-gray-200 dark:border-gray-700">
                                                {{ Auth::user()->email }}
                                                @if(Auth::user()->hasRole('Admin'))
                                                    <span class="block text-red-600 dark:text-red-400 font-medium">Administrator</span>
                                                @else
                                                    <span class="block text-red-600 dark:text-red-400 font-medium">Staff Member</span>
                                                @endif
                                            </div>
                                            <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-gray-900 dark:hover:text-white">
                                                <i class="fas fa-sign-out-alt mr-2"></i>Sign out
                                            </a>
                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="hidden">
                                                @csrf
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </header>

                    <!-- Page content -->
                    <main class="flex-1 overflow-y-auto bg-gray-50 dark:bg-transparent">
                        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
                            @if(session('success'))
                                <div class="mb-4 bg-green-100 dark:bg-green-900 border border-green-400 dark:border-green-700 text-green-700 dark:text-green-300 px-4 py-3 rounded-md">
                                    <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
                                </div>
                            @endif
                            
                            @if(session('error'))
                                <div class="mb-4 bg-red-100 dark:bg-red-900 border border-red-400 dark:border-red-700 text-red-700 dark:text-red-300 px-4 py-3 rounded-md">
                                    <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
                                </div>
                            @endif
                            
                            @yield('content')
                        </div>
                    </main>
                </div>
            </div>
        @else
            <!-- Guest layout -->
            <div class="min-h-screen bg-transparent flex flex-col justify-center py-12 sm:px-6 lg:px-8">
                @yield('content')
            </div>
        @endauth
    </div>

    <script>
        // Mobile sidebar toggle
        function toggleMobileSidebar() {
            const mobileSidebar = document.getElementById('mobile-sidebar');
            const overlay = document.getElementById('mobile-sidebar-overlay');
            
            if (mobileSidebar.classList.contains('-translate-x-full')) {
                // Show sidebar
                mobileSidebar.classList.remove('-translate-x-full');
                mobileSidebar.classList.add('translate-x-0');
                overlay.style.display = 'block';
            } else {
                // Hide sidebar
                mobileSidebar.classList.remove('translate-x-0');
                mobileSidebar.classList.add('-translate-x-full');
                overlay.style.display = 'none';
            }
        }

        // Event delegation for toggles to handle Vue re-renders
        document.addEventListener('click', function(event) {
            // User menu toggle
            const userMenuButton = event.target.closest('#user-menu-button');
            const userMenu = document.getElementById('user-menu');
            
            if (userMenuButton && userMenu) {
                userMenu.classList.toggle('hidden');
                event.stopPropagation(); // Prevent immediate closing
                return;
            }
            
            // Close user menu when clicking outside
            if (userMenu && !userMenu.classList.contains('hidden') && !event.target.closest('#user-menu')) {
                userMenu.classList.add('hidden');
            }
        });
    </script>
    
    @yield('scripts')
</body>
</html>
