@extends('layouts.app')

@section('page-title', 'Verify Email')

@section('content')
<div class="max-w-md mx-auto">
    <div class="bg-gray-800 rounded-lg shadow-xl border border-gray-700">
        <div class="px-6 py-4 border-b border-gray-700">
            <h1 class="text-xl font-bold text-white">
                <i class="fas fa-envelope-open mr-3 text-red-400"></i>
                {{ __('Verify Your Email Address') }}
            </h1>
        </div>

        <div class="p-6">
            @if (session('resent'))
                <div class="mb-4 bg-red-900 border border-red-700 text-red-300 px-4 py-3 rounded-md">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <div>{{ __('A fresh verification link has been sent to your email address.') }}</div>
                    </div>
                </div>
            @endif

            <div class="text-gray-300 mb-4">
                <p class="mb-2">{{ __('Before proceeding, please check your email for a verification link.') }}</p>
                <p>{{ __('If you did not receive the email') }}, 
                    <form class="inline" method="POST" action="{{ route('verification.resend') }}">
                        @csrf
                        <button type="submit" class="text-red-400 hover:text-red-300 underline font-medium transition-colors duration-200">
                            {{ __('click here to request another') }}
                        </button>.
                    </form>
                </p>
            </div>
        </div>
    </div>
</div>
@endsection
