<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permissions
        $permissions = [
            'manage staff',
            'mark attendance',
            'assign tasks',
            'reassign tasks',
            'view payroll',
            'view all tasks',
            'view own attendance',
            'view assigned tasks',
            'complete tasks',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create Admin role
        $adminRole = Role::firstOrCreate(['name' => 'Admin']);
        $adminRole->givePermissionTo([
            'manage staff',
            'mark attendance',
            'assign tasks',
            'reassign tasks',
            'view payroll',
            'view all tasks',
        ]);

        // Create Super Admin role
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);
        $superAdminRole->givePermissionTo([
            'manage staff',
            'mark attendance',
            'assign tasks',
            'reassign tasks',
            'view payroll',
            'view all tasks',
        ]);

        // Create Staff role
        $staffRole = Role::firstOrCreate(['name' => 'Staff']);
        $staffRole->givePermissionTo([
            'view own attendance',
            'view assigned tasks',
            'complete tasks',
            'reassign tasks',
        ]);
    }
}
