<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('staff_profiles', function (Blueprint $table) {
            $table->decimal('basic_salary', 10, 2)->nullable()->after('salary');
            $table->decimal('hra', 10, 2)->nullable()->after('basic_salary');
            $table->decimal('conveyance', 10, 2)->nullable()->after('hra');
            $table->decimal('special_allowance', 10, 2)->nullable()->after('conveyance');
            $table->decimal('employer_pf', 10, 2)->nullable()->after('special_allowance');
            $table->decimal('employer_esi', 10, 2)->nullable()->after('employer_pf');
            $table->decimal('employee_pf', 10, 2)->nullable()->after('employer_esi');
            $table->decimal('employee_esi', 10, 2)->nullable()->after('employee_pf');
            $table->decimal('professional_tax', 10, 2)->nullable()->after('employee_esi');
        });

        Schema::table('payrolls', function (Blueprint $table) {
            $table->decimal('basic_salary', 10, 2)->nullable()->after('monthly_compensation');
            $table->decimal('hra', 10, 2)->nullable()->after('basic_salary');
            $table->decimal('conveyance', 10, 2)->nullable()->after('hra');
            $table->decimal('special_allowance', 10, 2)->nullable()->after('conveyance');
            $table->decimal('gross_salary', 10, 2)->nullable()->after('special_allowance');
            $table->decimal('employer_pf', 10, 2)->nullable()->after('gross_salary');
            $table->decimal('employer_esi', 10, 2)->nullable()->after('employer_pf');
            $table->decimal('ctc', 10, 2)->nullable()->after('employer_esi');
            $table->decimal('employee_pf', 10, 2)->nullable()->after('ctc');
            $table->decimal('employee_esi', 10, 2)->nullable()->after('employee_pf');
            $table->decimal('professional_tax', 10, 2)->nullable()->after('employee_esi');
            $table->decimal('net_salary', 10, 2)->nullable()->after('professional_tax');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('staff_profiles', function (Blueprint $table) {
            $table->dropColumn([
                'basic_salary',
                'hra',
                'conveyance',
                'special_allowance',
                'employer_pf',
                'employer_esi',
                'employee_pf',
                'employee_esi',
                'professional_tax'
            ]);
        });

        Schema::table('payrolls', function (Blueprint $table) {
            $table->dropColumn([
                'basic_salary',
                'hra',
                'conveyance',
                'special_allowance',
                'gross_salary',
                'employer_pf',
                'employer_esi',
                'ctc',
                'employee_pf',
                'employee_esi',
                'professional_tax',
                'net_salary'
            ]);
        });
    }
};
