<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('designation')->nullable()->after('email');
            $table->foreignId('reports_to')->nullable()->after('designation')->constrained('users')->nullOnDelete();
        });

        Schema::table('attendances', function (Blueprint $table) {
            $table->timestamp('check_out_time')->nullable()->after('marked_at');
            $table->string('check_out_selfie_path')->nullable()->after('check_out_time');
            $table->decimal('check_out_latitude', 10, 8)->nullable()->after('check_out_selfie_path');
            $table->decimal('check_out_longitude', 11, 8)->nullable()->after('check_out_latitude');
            $table->string('check_out_location_address')->nullable()->after('check_out_longitude');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['reports_to']);
            $table->dropColumn(['designation', 'reports_to']);
        });

        Schema::table('attendances', function (Blueprint $table) {
            $table->dropColumn([
                'check_out_time',
                'check_out_selfie_path',
                'check_out_latitude',
                'check_out_longitude',
                'check_out_location_address'
            ]);
        });
    }
};
