<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_inventory', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100); // Company/Segment name
            $table->string('product', 50); // Product type (Brief, T-SHIRT, etc.)
            $table->string('style', 50); // Style code/number
            $table->string('color', 50); // Color (ASSTD, WHITE, BLACK, etc.)
            $table->string('size', 10); // Size (S, M, L, XL, etc.)
            $table->integer('batch_no'); // Batch number
            $table->integer('current_balance_qty'); // Current balance quantity
            $table->string('uploaded_by', 100)->nullable(); // User who uploaded this data
            $table->timestamp('uploaded_at')->nullable(); // When this data was uploaded
            $table->timestamps();
            
            // Add indexes for better performance on filtering with limited length
            $table->index('name');
            $table->index('product');
            $table->index('style');
            $table->index(['color', 'size']);
            $table->index('batch_no');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_inventory');
    }
};
