<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            // Add columns that the current system expects but are missing
            $table->time('check_in')->nullable()->after('date');
            $table->time('check_out')->nullable()->after('check_in');
            $table->decimal('hours_worked', 5, 2)->nullable()->after('check_out');
            
            // Modify status enum to include more options
            $table->enum('status', ['present', 'absent', 'late', 'half_day'])->default('present')->change();
            
            // Add notes column for admin remarks
            $table->text('notes')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            $table->dropColumn(['check_in', 'check_out', 'hours_worked', 'notes']);
            $table->enum('status', ['present', 'absent'])->default('present')->change();
        });
    }
};
