<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('staff_profiles', function (Blueprint $table) {
            $table->string('employee_id')->nullable()->unique()->after('user_id');
            $table->string('phone')->nullable()->after('employee_id');
            $table->text('address')->nullable()->after('phone');
            $table->string('position')->nullable()->after('department_id');
            $table->decimal('salary', 10, 2)->nullable()->after('position');
            $table->date('hire_date')->nullable()->after('salary');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('staff_profiles', function (Blueprint $table) {
            $table->dropColumn([
                'employee_id',
                'phone',
                'address',
                'position',
                'salary',
                'hire_date'
            ]);
        });
    }
};