<?php

namespace App\Traits;

trait AttendanceDataTransformer
{
    /**
     * Transform attendance data from snake_case to camelCase for mobile app compatibility
     *
     * @param \App\Models\Attendance $attendance
     * @return array
     */
    protected function transformAttendanceData($attendance)
    {
        return [
            'id' => $attendance->id,
            'userId' => $attendance->user_id,
            'date' => $attendance->date->format('Y-m-d'),
            'checkIn' => $attendance->check_in ? $attendance->check_in->format('H:i') : null,
            'checkOut' => $attendance->check_out ? $attendance->check_out->format('H:i') : null,
            'hoursWorked' => $attendance->hours_worked,
            'status' => $attendance->status,
            'notes' => $attendance->notes,
            'selfiePath' => $attendance->selfie_path,
            'latitude' => $attendance->latitude,
            'longitude' => $attendance->longitude,
            'locationAddress' => $attendance->location_address,
            'attendanceType' => $attendance->attendance_type,
            'markedAt' => $attendance->marked_at ? $attendance->marked_at->format('Y-m-d H:i:s') : null,
            'createdAt' => $attendance->created_at->format('Y-m-d H:i:s'),
            'updatedAt' => $attendance->updated_at->format('Y-m-d H:i:s'),
            'user' => $attendance->user ? [
                'id' => $attendance->user->id,
                'name' => $attendance->user->name,
                'email' => $attendance->user->email,
            ] : null,
        ];
    }

    /**
     * Transform multiple attendance records
     *
     * @param \Illuminate\Support\Collection|\Illuminate\Database\Eloquent\Collection $attendances
     * @return array
     */
    protected function transformAttendanceCollection($attendances)
    {
        return $attendances->map(function ($attendance) {
            return $this->transformAttendanceData($attendance);
        })->toArray();
    }
}