<?php

namespace App\Policies;

use App\Models\Attendance;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class AttendancePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user)
    {
        // Admin can view all attendance records
        // Staff can view their own attendance records (handled in controller)
        return $user->hasRole('Admin') || $user->hasRole('Staff');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Attendance $attendance)
    {
        // Admin can view any attendance record
        if ($user->hasRole('Admin')) {
            return true;
        }
        
        // Staff can only view their own attendance records
        return $user->hasRole('Staff') && $attendance->user_id === $user->id;
    }

    /**
     * Determine whether the user can view calendar for a specific user.
     */
    public function viewCalendar(User $user, User $targetUser)
    {
        // Admin can view any user's calendar
        if ($user->hasRole('Admin')) {
            return true;
        }
        
        // Staff can only view their own calendar
        return $user->hasRole('Staff') && $user->id === $targetUser->id;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user)
    {
        // Only Admin can create attendance records
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Attendance $attendance)
    {
        // Only Admin can update attendance records
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Attendance $attendance)
    {
        // Only Admin can delete attendance records
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Attendance $attendance)
    {
        // Only Admin can restore attendance records
        return $user->hasRole('Admin');
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Attendance $attendance)
    {
        // Only Admin can force delete attendance records
        return $user->hasRole('Admin');
    }
}