<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StaffProfile extends Model
{
    protected $fillable = [
        'user_id',
        'department_id',
        'work_days_per_week',
        'monthly_compensation',
        'employee_id',
        'phone',
        'address',
        'position',
        'bank_name',
        'bank_account_no',
        'ifsc_code',
        'salary',
        'basic_salary',
        'hra',
        'conveyance',
        'special_allowance',
        'employer_pf',
        'employer_esi',
        'employee_pf',
        'employee_esi',
        'professional_tax',
        'hire_date',
        'total_paid_leaves',
        'used_paid_leaves',
    ];

    protected $casts = [
        'monthly_compensation' => 'decimal:2',
        'salary' => 'decimal:2',
        'basic_salary' => 'decimal:2',
        'hra' => 'decimal:2',
        'conveyance' => 'decimal:2',
        'special_allowance' => 'decimal:2',
        'employer_pf' => 'decimal:2',
        'employer_esi' => 'decimal:2',
        'employee_pf' => 'decimal:2',
        'employee_esi' => 'decimal:2',
        'professional_tax' => 'decimal:2',
        'hire_date' => 'date',
        'used_paid_leaves' => 'decimal:1',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }
}
