<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    protected $fillable = [
        'name',
        'description',
    ];

    public function staffProfiles()
    {
        return $this->hasMany(StaffProfile::class);
    }

    public function tasks()
    {
        return $this->hasMany(Task::class, 'current_department_id');
    }

    public function staff()
    {
        return $this->hasManyThrough(User::class, StaffProfile::class, 'department_id', 'id', 'id', 'user_id');
    }
}
