<?php

namespace App\Http\Controllers;

use App\Models\Reimbursement;
use Illuminate\Http\Request;

class ReimbursementController extends Controller
{
    public function index()
    {
        $reimbursements = Reimbursement::with('user')
            ->latest()
            ->paginate(15);
            
        return view('reimbursements.index', compact('reimbursements'));
    }

    public function updateStatus(Request $request, Reimbursement $reimbursement)
    {
        $request->validate([
            'status' => 'required|in:approved,rejected',
            'approved_amount' => 'nullable|numeric|min:0',
            'admin_comment' => 'nullable|string',
        ]);

        $data = [
            'status' => $request->status,
            'admin_comment' => $request->admin_comment,
        ];

        if ($request->status === 'approved') {
            $data['approved_amount'] = $request->input('approved_amount', $reimbursement->amount);
        }

        $reimbursement->update($data);

        return redirect()->back()->with('success', 'Reimbursement status updated.');
    }
}
