<?php

namespace App\Http\Controllers;

use App\Models\LeaveType;
use Illuminate\Http\Request;

class LeaveTypeController extends Controller
{
    public function index()
    {
        $leaveTypes = LeaveType::all();
        
        if (request()->wantsJson()) {
            return response()->json($leaveTypes);
        }
        
        return view('leaves.types.index', compact('leaveTypes'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'is_paid' => 'boolean',
            'deduction_percentage' => 'required|numeric|min:0|max:100',
        ]);

        $leaveType = LeaveType::create($validated);
        
        if (request()->wantsJson()) {
            return response()->json($leaveType, 201);
        }
        
        return redirect()->route('leaves.types.index')->with('success', 'Leave type created successfully.');
    }

    public function update(Request $request, LeaveType $leaveType)
    {
        $validated = $request->validate([
            'name' => 'string|max:255',
            'description' => 'nullable|string',
            'is_paid' => 'boolean',
            'deduction_percentage' => 'numeric|min:0|max:100',
        ]);

        $leaveType->update($validated);
        
        if (request()->wantsJson()) {
            return response()->json($leaveType);
        }
        
        return redirect()->route('leaves.types.index')->with('success', 'Leave type updated successfully.');
    }

    public function destroy(LeaveType $leaveType)
    {
        $leaveType->delete();
        
        if (request()->wantsJson()) {
            return response()->json(null, 204);
        }
        
        return redirect()->route('leaves.types.index')->with('success', 'Leave type deleted successfully.');
    }
}
